/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.UnresolvedType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TypeDDLTestSuite {
    static final String CREATE_TYPE_PREFIX = "CREATE OR REPLACE TYPE ";
    static DDLParser parser = null;
    static final String SIMPLE_TYPE = "EMP_INFO";
    static final String SIMPLE_TYPE_FIELD1_NAME = "ID";
    static final String SIMPLE_TYPE_FIELD1_TYPE = "NUMERIC(5)";
    static final String SIMPLE_TYPE_FIELD2_NAME = "NAME";
    static final String SIMPLE_TYPE_FIELD2_TYPE = "VARCHAR2(50)";
    static final String CREATE_SIMPLE_TYPE = "CREATE OR REPLACE TYPE EMP_INFO IS OBJECT (\nID NUMERIC(5),\nNAME VARCHAR2(50)\n);";
    static final String GUID_TABLE_TYPE = "GUID_PACKAGE_GUID_ARRAY";
    static final String CREATE_GUID_TABLE_TYPE = "CREATE OR REPLACE TYPE GUID_PACKAGE_GUID_ARRAY AS TABLE OF VARCHAR2(20);";
    static final String VCARRAY_VARRAY_TYPE = "VCARRAY";
    static final String CREATE_VCARRAY_VARRAY_TYPE = "CREATE OR REPLACE TYPE VCARRAY AS VARRAY(4) OF VARCHAR2(20);";
    static final String TYPE_WITH_UNRESOLVED_TYPE = "EMPLOYEE_CONTACT";
    static final String TWUT_FIELD1_NAME = "EMP_NUMBER";
    static final String TWUT_FIELD1_TYPE = "NUMERIC";
    static final String TWUT_FIELD2_NAME = "EMP_NAME";
    static final String TWUT_FIELD2_TYPE = "VARCHAR2(50)";
    static final String TWUT_FIELD3_NAME = "HOME_CONTACT";
    static final String TWUT_FIELD3_TYPE = "HR.CONTACT";
    static final String TWUT_FIELD4_NAME = "WORK_CONTACT";
    static final String TWUT_FIELD4_TYPE = "HR.CONTACT";
    static final String CREATE_TYPE_WITH_UNRESOLVED_TYPE = "CREATE OR REPLACE TYPE EMPLOYEE_CONTACT IS OBJECT (\nEMP_NUMBER NUMERIC,\nEMP_NAME VARCHAR2(50),\nHOME_CONTACT HR.CONTACT,\nWORK_CONTACT HR.CONTACT\n);";
    static final String TYPE_W_KEYWORDS = "KEYWORD_TYPE";
    static final String TWKW_FIELD1_NAME = "OID";
    static final String TWKW_FIELD1_TYPE = "VARCHAR2(50)";
    static final String TWKW_FIELD2_NAME = "CODE";
    static final String TWKW_FIELD2_TYPE = "VARCHAR2 (2)";
    static final String CREATE_TYPE_WITH_KEYWORD = "CREATE OR REPLACE TYPE KEYWORD_TYPE IS OBJECT (\nOID VARCHAR2(50),\nCODE VARCHAR2 (2)\n);";

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void testSimpleType() {
        parser.ReInit(new StringReader(CREATE_SIMPLE_TYPE));
        boolean worked = true;
        String message = "";
        ObjectType simpleType = null;
        try {
            simpleType = (ObjectType)parser.parseType();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("EMP_INFO type did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(simpleType);
        Assert.assertTrue((String)"EMP_INFO type should not contain unresolved column datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        List<FieldType> fields = simpleType.getFields();
        Assert.assertEquals((String)"EMP_INFO type should contain 2 column fields", (long)2L, (long)fields.size());
        FieldType field1 = fields.get(0);
        Assert.assertEquals((String)"incorrect name for ID field ", (Object)SIMPLE_TYPE_FIELD1_NAME, (Object)field1.getFieldName());
        Assert.assertEquals((String)"incorrect type for ID field ", (Object)SIMPLE_TYPE_FIELD1_TYPE, (Object)field1.getEnclosedType().toString());
        FieldType field2 = fields.get(1);
        Assert.assertEquals((String)"incorrect name for NAME field ", (Object)SIMPLE_TYPE_FIELD2_NAME, (Object)field2.getFieldName());
        Assert.assertEquals((String)"incorrect type for NAME field ", (Object)"VARCHAR2(50)", (Object)field2.getEnclosedType().toString());
    }

    @Test
    public void testObjectTableType() {
        parser.ReInit(new StringReader(CREATE_GUID_TABLE_TYPE));
        boolean worked = true;
        String message = "";
        ObjectTableType objectTableType = null;
        try {
            objectTableType = (ObjectTableType)parser.parseType();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("GUID_PACKAGE_GUID_ARRAY type did not parse:\n" + message), (boolean)worked);
        Assert.assertEquals((String)"GUID_PACKAGE_GUID_ARRAY type wrong name", (Object)GUID_TABLE_TYPE, (Object)objectTableType.getTypeName());
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(objectTableType);
        List<UnresolvedType> unresolvedTypes = l.getUnresolvedTypes();
        Assert.assertTrue((String)"GUID_PACKAGE_GUID_ARRAY type should not contain unresolved column datatypes", (boolean)unresolvedTypes.isEmpty());
        Assert.assertEquals((String)"incorrect table type for GUID_PACKAGE_GUID_ARRAY", (Object)"VARCHAR2(20)", (Object)objectTableType.getEnclosedType().toString());
    }

    @Test
    public void testVArrayType() {
        parser.ReInit(new StringReader(CREATE_VCARRAY_VARRAY_TYPE));
        boolean worked = true;
        String message = "";
        VArrayType varrayType = null;
        try {
            varrayType = (VArrayType)parser.parseType();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("VCARRAY type did not parse:\n" + message), (boolean)worked);
        Assert.assertEquals((String)"VCARRAY type wrong name", (Object)VCARRAY_VARRAY_TYPE, (Object)varrayType.getTypeName());
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(varrayType);
        List<UnresolvedType> unresolvedTypes = l.getUnresolvedTypes();
        Assert.assertTrue((String)"VCARRAY type should not contain unresolved column datatypes", (boolean)unresolvedTypes.isEmpty());
        Assert.assertEquals((String)"VCARRAY's size be 4", (long)4L, (long)varrayType.getSize());
        Assert.assertEquals((String)"incorrect enclosed type for VCARRAY", (Object)"VARCHAR2(20)", (Object)varrayType.getEnclosedType().toString());
    }

    @Test
    public void testTypeWithUnresolvedType() {
        parser.ReInit(new StringReader(CREATE_TYPE_WITH_UNRESOLVED_TYPE));
        boolean worked = true;
        String message = "";
        ObjectType typeWithUnresolvedType = null;
        try {
            typeWithUnresolvedType = (ObjectType)parser.parseType();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("EMPLOYEE_CONTACT type did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(typeWithUnresolvedType);
        List<UnresolvedType> unresolvedTypes = l.getUnresolvedTypes();
        Assert.assertFalse((String)"EMPLOYEE_CONTACT type should contain unresolved column datatypes", (boolean)unresolvedTypes.isEmpty());
        Assert.assertEquals((String)"EMPLOYEE_CONTACT type should contain 2 unresolved column datatypes", (long)2L, (long)unresolvedTypes.size());
        List<FieldType> fields = typeWithUnresolvedType.getFields();
        Assert.assertEquals((String)"EMPLOYEE_CONTACT type should contain 4 column fields", (long)4L, (long)fields.size());
        FieldType field1 = fields.get(0);
        Assert.assertEquals((String)"incorrect name for EMP_NUMBER field ", (Object)TWUT_FIELD1_NAME, (Object)field1.getFieldName());
        Assert.assertEquals((String)"incorrect type for EMP_NUMBER field ", (Object)TWUT_FIELD1_TYPE, (Object)field1.getEnclosedType().toString());
        FieldType field2 = fields.get(1);
        Assert.assertEquals((String)"incorrect name for EMP_NAME field ", (Object)TWUT_FIELD2_NAME, (Object)field2.getFieldName());
        Assert.assertEquals((String)"incorrect type for EMP_NAME field ", (Object)"VARCHAR2(50)", (Object)field2.getEnclosedType().toString());
        FieldType field3 = fields.get(2);
        Assert.assertEquals((String)"incorrect name for HOME_CONTACT field ", (Object)TWUT_FIELD3_NAME, (Object)field3.getFieldName());
        Assert.assertEquals((String)"incorrect type for HOME_CONTACT field ", (Object)"HR.CONTACT", (Object)field3.getEnclosedType().toString());
        FieldType field4 = fields.get(3);
        Assert.assertEquals((String)"incorrect name for WORK_CONTACT field ", (Object)TWUT_FIELD4_NAME, (Object)field4.getFieldName());
        Assert.assertEquals((String)"incorrect type for WORK_CONTACT field ", (Object)"HR.CONTACT", (Object)field4.getEnclosedType().toString());
    }

    @Test
    public void testKeywordType() {
        parser.ReInit(new StringReader(CREATE_TYPE_WITH_KEYWORD));
        boolean worked = true;
        String message = "";
        ObjectType typeWithKeyword = null;
        try {
            typeWithKeyword = (ObjectType)parser.parseType();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("type with keyword did not parse:\n" + message), (boolean)worked);
        Assert.assertEquals((String)"incorrect type name KEYWORD_TYPE", (Object)TYPE_W_KEYWORDS, (Object)typeWithKeyword.getTypeName());
    }
}

