/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitable;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class PLSQLRecordType
extends PLSQLType
implements DatabaseTypeVisitable {
    protected List<FieldType> fields = new ArrayList<FieldType>();

    public PLSQLRecordType(String recordName) {
        super(recordName);
    }

    public List<FieldType> getFields() {
        return this.fields;
    }

    public void addField(DatabaseType databaseType) {
        if (databaseType.isFieldType()) {
            this.fields.add((FieldType)databaseType);
        } else {
            for (FieldType fld : this.fields) {
                if (!fld.getEnclosedType().getTypeName().equals(databaseType.getTypeName())) continue;
                fld.setEnclosedType(databaseType);
            }
        }
    }

    @Override
    public DatabaseType getEnclosedType() {
        return null;
    }

    @Override
    public void setEnclosedType(DatabaseType enclosedType) {
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isResolved() {
        for (FieldType fType : this.fields) {
            if (fType.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPLSQLRecordType() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (");
        Iterator<FieldType> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            FieldType f = iterator.next();
            sb.append("\n\t");
            sb.append(f.toString());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("\n)");
        return sb.toString();
    }
}

