/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.AttributeGroup;

public class CopyGroup
extends AttributeGroup {
    protected boolean shouldResetPrimaryKey;
    protected boolean shouldResetVersion;
    protected AbstractSession session;
    protected Map copies = new IdentityHashMap();
    protected int depth = 2;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;
    public static final int CASCADE_TREE = 4;

    public CopyGroup() {
    }

    public CopyGroup(String name) {
        super(name);
    }

    public void cascadeAllParts() {
        this.setDepth(3);
    }

    public void cascadePrivateParts() {
        this.setDepth(2);
    }

    public void cascadeTree() {
        this.setDepth(4);
    }

    public void dontCascade() {
        this.setDepth(1);
    }

    public Map getCopies() {
        return this.copies;
    }

    public int getDepth() {
        return this.depth;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setCopies(Map newCopies) {
        this.copies = newCopies;
    }

    public void setDepth(int newDepth) {
        this.depth = newDepth;
    }

    public void setSession(AbstractSession newSession) {
        this.session = newSession;
    }

    public void setShouldResetPrimaryKey(boolean newShouldResetPrimaryKey) {
        this.shouldResetPrimaryKey = newShouldResetPrimaryKey;
    }

    public void setShouldResetVersion(boolean newShouldResetVersion) {
        this.shouldResetVersion = newShouldResetVersion;
    }

    public boolean shouldCascade() {
        return this.getDepth() != 1;
    }

    public boolean shouldCascadeAllParts() {
        return this.getDepth() == 3;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getDepth() == 2;
    }

    public boolean shouldCascadeTree() {
        return this.getDepth() == 4;
    }

    public boolean shouldResetPrimaryKey() {
        return this.shouldResetPrimaryKey;
    }

    public boolean shouldResetVersion() {
        return this.shouldResetVersion;
    }

    @Override
    protected String toStringAdditionalInfo() {
        String depthString = "";
        depthString = this.shouldCascadeAllParts() ? "CASCADE_ALL_PARTS" : (this.shouldCascadePrivateParts() ? "CASCADE_PRIVATE_PARTS" : (this.shouldCascadeTree() ? "CASCADE_TREE" : "NO_CASCADE"));
        Object[] args = new Object[]{depthString, this.shouldResetPrimaryKey(), this.shouldResetVersion()};
        return ToStringLocalization.buildMessage("depth_reset_key", args);
    }

    @Override
    public void addAttribute(String attributeNameOrPath, AttributeGroup group) {
        this.cascadeTree();
        if (group == null) {
            super.addAttribute(attributeNameOrPath, (AttributeGroup)null);
        } else {
            this.addAttribute(attributeNameOrPath, group.toCopyGroup());
        }
    }

    public void addAttribute(String attributeNameOrPath, CopyGroup group) {
        this.cascadeTree();
        if (group != null) {
            group.setCopies(this.getCopies());
            group.cascadeTree();
        }
        super.addAttribute(attributeNameOrPath, group);
    }

    @Override
    public boolean isCopyGroup() {
        return true;
    }

    @Override
    public CopyGroup clone() {
        CopyGroup clone = (CopyGroup)super.clone();
        clone.copies = new IdentityHashMap();
        return clone;
    }

    @Override
    public CopyGroup getGroup(String attributeNameOrPath) {
        return (CopyGroup)super.getGroup(attributeNameOrPath);
    }

    @Override
    protected CopyGroup newGroup(String name, AttributeGroup parent) {
        CopyGroup copyGroup = new CopyGroup(name);
        copyGroup.cascadeTree();
        if (parent != null) {
            copyGroup.setShouldResetPrimaryKey(((CopyGroup)parent).shouldResetPrimaryKey());
            copyGroup.setShouldResetVersion(((CopyGroup)parent).shouldResetVersion());
            copyGroup.setCopies(((CopyGroup)parent).getCopies());
        }
        return copyGroup;
    }
}

