/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.SimpleDatabaseType;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

public enum OraclePLSQLTypes implements SimpleDatabaseType,
OraclePLSQLType
{
    BinaryInteger("BINARY_INTEGER"),
    Dec("DEC"),
    Int("INT"),
    Natural("NATURAL"),
    NaturalN("NATURALN"){

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, outArg, this);
            sb.append(" := 1;");
            sb.append(Helper.NL);
        }
    }
    ,
    PLSQLBoolean("BOOLEAN"){

        @Override
        public int getConversionCode() {
            return JDBCTypes.INTEGER_TYPE.getConversionCode();
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, inArg, this);
            sb.append(" := ");
            sb.append("SYS.SQLJUTL.INT2BOOL");
            sb.append("(:");
            sb.append(inArg.inIndex);
            sb.append(");");
            sb.append(Helper.NL);
        }

        @Override
        public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg, PLSQLStoredProcedureCall call) {
            sb.append("  :");
            sb.append(outArg.outIndex);
            sb.append(" := ");
            sb.append("SYS.SQLJUTL.BOOL2INT");
            sb.append("(");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg));
            sb.append(");");
            sb.append(Helper.NL);
        }
    }
    ,
    PLSQLInteger("PLS_INTEGER"),
    Positive("POSITIVE"),
    PositiveN("POSITIVEN"){

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, outArg, this);
            sb.append(" := 1;");
            sb.append(Helper.NL);
        }
    }
    ,
    SignType("SIGNTYPE"),
    XMLType("XMLTYPE"){

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append(Helper.NL);
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append(Helper.NL);
        }

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            sb.append("  ");
            sb.append(arg.name);
            sb.append("TARGET");
            sb.append(" ");
            sb.append(this.getTypeName());
        }

        @Override
        public int getSqlCode() {
            return 2007;
        }

        @Override
        public int getConversionCode() {
            return this.getSqlCode();
        }
    };

    private final String typeName;

    private OraclePLSQLTypes(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public boolean isComplexDatabaseType() {
        return false;
    }

    @Override
    public int getSqlCode() {
        return 1111;
    }

    @Override
    public int getConversionCode() {
        return JDBCTypes.NUMERIC_TYPE.getConversionCode();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isJDBCType() {
        return false;
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(inArg, newIndex);
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(outArg, newIndex);
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, inArg, this);
        sb.append(" := :");
        sb.append(inArg.inIndex);
        sb.append(";");
        sb.append(Helper.NL);
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, outArg, this);
        sb.append(";");
        sb.append(Helper.NL);
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg, PLSQLStoredProcedureCall call) {
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument arg, PLSQLStoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutAssignment(sb, arg, call);
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, List<DatabaseField> copyOfTranslationFields, List<DatabaseField> translationRowFields, List translationRowValues, StoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, call);
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, List<DatabaseField> outputRowFields, List outputRowValues) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
    }

    @Override
    public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(sb, direction, arg, translationRow, platform);
    }

    public static DatabaseType getDatabaseTypeForCode(String typeName) {
        OraclePLSQLTypes databaseType = null;
        if (OraclePLSQLTypes.BinaryInteger.typeName.equalsIgnoreCase(typeName)) {
            databaseType = BinaryInteger;
        } else if (OraclePLSQLTypes.Dec.typeName.equalsIgnoreCase(typeName)) {
            databaseType = Dec;
        } else if (OraclePLSQLTypes.Int.typeName.equalsIgnoreCase(typeName)) {
            databaseType = Int;
        } else if (OraclePLSQLTypes.Natural.typeName.equalsIgnoreCase(typeName)) {
            databaseType = Natural;
        } else if (OraclePLSQLTypes.NaturalN.typeName.equalsIgnoreCase(typeName)) {
            databaseType = NaturalN;
        } else if (OraclePLSQLTypes.PLSQLBoolean.typeName.equalsIgnoreCase(typeName) || "BOOLEAN".equalsIgnoreCase(typeName)) {
            databaseType = PLSQLBoolean;
        } else if (OraclePLSQLTypes.PLSQLInteger.typeName.equalsIgnoreCase(typeName)) {
            databaseType = PLSQLInteger;
        } else if (OraclePLSQLTypes.Positive.typeName.equalsIgnoreCase(typeName)) {
            databaseType = Positive;
        } else if (OraclePLSQLTypes.PositiveN.typeName.equalsIgnoreCase(typeName)) {
            databaseType = PositiveN;
        } else if (OraclePLSQLTypes.SignType.typeName.equalsIgnoreCase(typeName)) {
            databaseType = SignType;
        } else if (OraclePLSQLTypes.XMLType.typeName.equalsIgnoreCase(typeName)) {
            databaseType = XMLType;
        }
        return databaseType;
    }

    /* synthetic */ OraclePLSQLTypes(String string, int n, String string2, OraclePLSQLTypes oraclePLSQLTypes) {
        this(string2);
    }
}

