/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;

public abstract class DescriptorIterator {
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    protected Map visitedObjects = new IdentityHashMap();
    protected Stack visitedStack = new Stack();
    protected AbstractSession session;
    protected DatabaseMapping currentMapping;
    protected ClassDescriptor currentDescriptor;
    protected AttributeItem currentItem;
    protected AttributeGroup currentGroup;
    protected boolean usesGroup;
    protected boolean shouldTrackCurrentGroup;
    protected Object result;
    protected boolean shouldIterateOverIndirectionObjects = true;
    protected boolean shouldIterateOverUninstantiatedIndirectionObjects = false;
    protected boolean shouldIterateOverWrappedObjects = true;
    protected boolean shouldIterateOnIndirectionObjects = false;
    protected boolean shouldIterateOnAggregates = false;
    protected boolean shouldIterateOnPrimitives = false;
    protected boolean shouldIterateOnFetchGroupAttributesOnly = false;
    protected boolean shouldBreak = false;
    protected int cascadeDepth = 3;
    protected CascadeCondition cascadeCondition = new CascadeCondition();

    public int getCascadeDepth() {
        return this.cascadeDepth;
    }

    public ClassDescriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public DatabaseMapping getCurrentMapping() {
        return this.currentMapping;
    }

    public AttributeItem getCurrentItem() {
        return this.currentItem;
    }

    public AttributeGroup getCurrentGroup() {
        return this.currentGroup;
    }

    protected ClassDescriptor getDescriptorFor(Object object) {
        ClassDescriptor result = this.getSession().getDescriptor(object);
        if (result == null) {
            throw DescriptorException.missingDescriptor(object.getClass().getName());
        }
        return result;
    }

    public Object getResult() {
        return this.result;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getVisitedGrandparent() {
        Object parent = this.getVisitedStack().pop();
        Object result = this.getVisitedStack().peek();
        this.getVisitedStack().push(parent);
        return result;
    }

    public Map getVisitedObjects() {
        return this.visitedObjects;
    }

    public Object getVisitedParent() {
        return this.getVisitedStack().peek();
    }

    public Stack getVisitedStack() {
        return this.visitedStack;
    }

    protected void internalIterateAggregateObject(Object aggregateObject) {
        this.iterate(aggregateObject);
    }

    protected void internalIterateIndirectContainer(IndirectContainer container) {
        this.iterate(container);
    }

    protected void internalIteratePrimitive(Object primitiveValue) {
        this.iterate(primitiveValue);
    }

    protected void internalIterateReferenceObject(Object referenceObject) {
        this.iterate(referenceObject);
    }

    protected void internalIterateValueHolder(ValueHolderInterface valueHolder) {
        this.iterate(valueHolder);
    }

    protected abstract void iterate(Object var1);

    public void iterateForAggregateMapping(Object aggregateObject, DatabaseMapping mapping, ClassDescriptor descriptor) {
        if (aggregateObject == null) {
            return;
        }
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(descriptor);
        AttributeGroup currentGroupOriginal = null;
        AttributeItem currentItemOriginal = null;
        if (this.usesGroup) {
            currentGroupOriginal = this.currentGroup;
            currentItemOriginal = this.currentItem;
            this.currentGroup = this.currentItem.getGroup();
        }
        if (this.shouldIterateOnAggregates()) {
            this.internalIterateAggregateObject(aggregateObject);
            if (this.shouldBreak()) {
                this.setShouldBreak(false);
                if (this.usesGroup) {
                    this.currentGroup = currentGroupOriginal;
                    this.currentItem = currentItemOriginal;
                }
                return;
            }
        }
        this.iterateReferenceObjects(aggregateObject);
        if (this.usesGroup) {
            this.currentGroup = currentGroupOriginal;
            this.currentItem = currentItemOriginal;
        }
    }

    public void iterateIndirectContainerForMapping(IndirectContainer container, DatabaseMapping mapping) {
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnIndirectionObjects()) {
            this.internalIterateIndirectContainer(container);
        }
        if (this.shouldIterateOverUninstantiatedIndirectionObjects() || this.shouldIterateOverIndirectionObjects() && container.isInstantiated()) {
            mapping.iterateOnRealAttributeValue(this, container);
        } else if (this.shouldIterateOverIndirectionObjects() && container instanceof IndirectCollection) {
            mapping.iterateOnRealAttributeValue(this, ((IndirectCollection)container).getAddedElements());
        }
    }

    public void iteratePrimitiveForMapping(Object primitiveValue, DatabaseMapping mapping) {
        if (primitiveValue == null) {
            return;
        }
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnPrimitives()) {
            AttributeGroup currentGroupOriginal = null;
            AttributeItem currentItemOriginal = null;
            if (this.usesGroup) {
                currentGroupOriginal = this.currentGroup;
                currentItemOriginal = this.currentItem;
                this.currentGroup = this.currentItem.getGroup();
            }
            this.internalIteratePrimitive(primitiveValue);
            if (this.usesGroup) {
                this.currentGroup = currentGroupOriginal;
                this.currentItem = currentItemOriginal;
            }
        }
    }

    public void iterateReferenceObjectForMapping(Object referenceObject, DatabaseMapping mapping) {
        if (this.cascadeCondition.shouldNotCascade(mapping)) {
            return;
        }
        ClassDescriptor rd = mapping.getReferenceDescriptor();
        if (!this.shouldIterateOverWrappedObjects() && rd != null && rd.hasWrapperPolicy()) {
            return;
        }
        if (referenceObject == null) {
            return;
        }
        if (this.usesGroup && this.shouldTrackCurrentGroup) {
            HashSet<AttributeGroup> visited = (HashSet<AttributeGroup>)this.getVisitedObjects().get(referenceObject);
            if (visited == null) {
                visited = new HashSet<AttributeGroup>(1);
                visited.add(this.currentItem.getGroup());
                this.getVisitedObjects().put(referenceObject, visited);
            } else {
                if (visited.contains(this.currentItem.getGroup())) {
                    return;
                }
                visited.add(this.currentItem.getGroup());
            }
        } else {
            if (this.getVisitedObjects().containsKey(referenceObject)) {
                return;
            }
            this.getVisitedObjects().put(referenceObject, referenceObject);
        }
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(this.getDescriptorFor(referenceObject));
        AttributeGroup currentGroupOriginal = null;
        AttributeItem currentItemOriginal = null;
        if (this.usesGroup) {
            currentGroupOriginal = this.currentGroup;
            currentItemOriginal = this.currentItem;
            this.currentGroup = this.currentItem.getGroup();
        }
        this.internalIterateReferenceObject(referenceObject);
        if (this.shouldBreak()) {
            this.setShouldBreak(false);
            if (this.usesGroup) {
                this.currentGroup = currentGroupOriginal;
                this.currentItem = currentItemOriginal;
            }
            return;
        }
        this.iterateReferenceObjects(referenceObject);
        if (this.usesGroup) {
            this.currentGroup = currentGroupOriginal;
            this.currentItem = currentItemOriginal;
        }
    }

    protected void iterateReferenceObjects(Object sourceObject) {
        if (this.usesGroup && (this.currentGroup == null || !this.currentGroup.hasItems())) {
            return;
        }
        this.getVisitedStack().push(sourceObject);
        this.internalIterateReferenceObjects(sourceObject);
        this.getVisitedStack().pop();
    }

    protected void internalIterateReferenceObjects(Object sourceObject) {
        FetchGroup fetchGroup;
        List<DatabaseMapping> mappings;
        if (this.shouldIterateOnPrimitives()) {
            mappings = this.getCurrentDescriptor().getObjectBuilder().getDescriptor().getMappings();
        } else {
            ObjectBuilder builder = this.getCurrentDescriptor().getObjectBuilder().getDescriptor().getObjectBuilder();
            if (builder.isSimple()) {
                return;
            }
            mappings = builder.getRelationshipMappings();
        }
        if (this.shouldIterateOnFetchGroupAttributesOnly() && this.getCurrentDescriptor().hasFetchGroupManager() && (fetchGroup = this.getCurrentDescriptor().getFetchGroupManager().getObjectFetchGroup(sourceObject)) != null) {
            ArrayList<DatabaseMapping> fetchGroupMappings = new ArrayList<DatabaseMapping>();
            for (DatabaseMapping mapping : mappings) {
                if (!fetchGroup.containsAttributeInternal(mapping.getAttributeName())) continue;
                fetchGroupMappings.add(mapping);
            }
            mappings = fetchGroupMappings;
        }
        if (this.usesGroup) {
            AttributeGroup currentGroupOriginal = this.currentGroup;
            AttributeItem currentItemOriginal = this.currentItem;
            for (DatabaseMapping mapping : mappings) {
                this.currentItem = this.currentGroup.getItem(mapping.getAttributeName());
                if (this.currentItem == null) continue;
                mapping.iterate(this);
                this.currentGroup = currentGroupOriginal;
            }
            this.currentItem = currentItemOriginal;
        } else {
            for (DatabaseMapping mapping : mappings) {
                mapping.iterate(this);
            }
        }
    }

    public void iterateValueHolderForMapping(ValueHolderInterface valueHolder, DatabaseMapping mapping) {
        this.setCurrentMapping(mapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnIndirectionObjects()) {
            this.internalIterateValueHolder(valueHolder);
        }
        if (this.shouldIterateOverUninstantiatedIndirectionObjects() || this.shouldIterateOverIndirectionObjects() && valueHolder.isInstantiated()) {
            mapping.iterateOnRealAttributeValue(this, valueHolder.getValue());
        }
    }

    public void setCascadeDepth(int cascadeDepth) {
        this.cascadeDepth = cascadeDepth;
    }

    public void setCascadeCondition(CascadeCondition cascadeCondition) {
        this.cascadeCondition = cascadeCondition;
    }

    public void setCurrentDescriptor(ClassDescriptor currentDescriptor) {
        this.currentDescriptor = currentDescriptor;
    }

    public void setCurrentMapping(DatabaseMapping currentMapping) {
        this.currentMapping = currentMapping;
    }

    public void setCurrentItem(AttributeItem item) {
        this.currentItem = item;
    }

    public void setCurrentGroup(AttributeGroup group) {
        this.currentGroup = group;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setShouldBreak(boolean shouldBreak) {
        this.shouldBreak = shouldBreak;
    }

    public void setShouldIterateOnAggregates(boolean shouldIterateOnAggregates) {
        this.shouldIterateOnAggregates = shouldIterateOnAggregates;
    }

    public void setShouldIterateOnFetchGroupAttributesOnly(boolean shouldIterateOnFetchGroupAttributesOnly) {
        this.shouldIterateOnFetchGroupAttributesOnly = shouldIterateOnFetchGroupAttributesOnly;
    }

    public void setShouldIterateOnIndirectionObjects(boolean shouldIterateOnIndirectionObjects) {
        this.shouldIterateOnIndirectionObjects = shouldIterateOnIndirectionObjects;
    }

    public void setShouldIterateOnPrimitives(boolean shouldIterateOnPrimitives) {
        this.shouldIterateOnPrimitives = shouldIterateOnPrimitives;
    }

    public void setShouldIterateOverIndirectionObjects(boolean shouldIterateOverIndirectionObjects) {
        this.shouldIterateOverIndirectionObjects = shouldIterateOverIndirectionObjects;
    }

    public void setShouldIterateOverUninstantiatedIndirectionObjects(boolean shouldIterateOverUninstantiatedIndirectionObjects) {
        this.shouldIterateOverUninstantiatedIndirectionObjects = shouldIterateOverUninstantiatedIndirectionObjects;
    }

    public void setShouldIterateOverWrappedObjects(boolean shouldIterateOverWrappedObjects) {
        this.shouldIterateOverWrappedObjects = shouldIterateOverWrappedObjects;
    }

    public void setShouldTrackCurrentGroup(boolean shouldTrackCurrentGroup) {
        this.shouldTrackCurrentGroup = shouldTrackCurrentGroup;
    }

    public void setVisitedObjects(Map visitedObjects) {
        this.visitedObjects = visitedObjects;
    }

    protected void setVisitedStack(Stack visitedStack) {
        this.visitedStack = visitedStack;
    }

    public boolean shouldBreak() {
        return this.shouldBreak;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadeDepth() == 3;
    }

    public boolean shouldCascadeNoParts() {
        return this.getCascadeDepth() == 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadeDepth() == 3 || this.getCascadeDepth() == 2;
    }

    public boolean shouldIterateOnAggregates() {
        return this.shouldIterateOnAggregates;
    }

    public boolean shouldIterateOnFetchGroupAttributesOnly() {
        return this.shouldIterateOnFetchGroupAttributesOnly;
    }

    public boolean shouldIterateOnIndirectionObjects() {
        return this.shouldIterateOnIndirectionObjects;
    }

    public boolean shouldIterateOnPrimitives() {
        return this.shouldIterateOnPrimitives;
    }

    public boolean shouldIterateOverIndirectionObjects() {
        return this.shouldIterateOverIndirectionObjects;
    }

    public boolean shouldIterateOverUninstantiatedIndirectionObjects() {
        return this.shouldIterateOverUninstantiatedIndirectionObjects;
    }

    public boolean shouldIterateOverWrappedObjects() {
        return this.shouldIterateOverWrappedObjects;
    }

    public boolean shouldTrackCurrentGroup() {
        return this.shouldTrackCurrentGroup;
    }

    public boolean usesGroup() {
        return this.usesGroup;
    }

    public void startIterationOn(Object sourceObject) {
        this.startIterationOn(sourceObject, null);
    }

    public void startIterationOn(Object sourceObject, AttributeGroup group) {
        boolean bl = this.usesGroup = group != null;
        if (this.usesGroup && this.shouldTrackCurrentGroup) {
            HashSet<AttributeGroup> visited = (HashSet<AttributeGroup>)this.getVisitedObjects().get(sourceObject);
            if (visited == null) {
                visited = new HashSet<AttributeGroup>(1);
                visited.add(group);
                this.getVisitedObjects().put(sourceObject, visited);
            } else {
                if (visited.contains(group)) {
                    return;
                }
                visited.add(group);
            }
        } else {
            if (this.getVisitedObjects().containsKey(sourceObject)) {
                return;
            }
            this.getVisitedObjects().put(sourceObject, sourceObject);
        }
        this.setCurrentMapping(null);
        this.setCurrentDescriptor(this.getSession().getDescriptor(sourceObject));
        this.setCurrentItem(null);
        this.setCurrentGroup(group);
        this.iterate(sourceObject);
        if (this.getCurrentDescriptor() != null && !this.shouldCascadeNoParts() && !this.shouldBreak()) {
            this.iterateReferenceObjects(sourceObject);
        }
    }

    public class CascadeCondition {
        public boolean shouldNotCascade(DatabaseMapping mapping) {
            return !DescriptorIterator.this.shouldCascadeAllParts() && (!DescriptorIterator.this.shouldCascadePrivateParts() || !mapping.isPrivateOwned());
        }
    }
}

