/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.Util;

public class JarArchiver
implements DBWSPackager.Archiver {
    static final int BUF_SIZE = 1024;
    static final String DEFAULT_JAR_FILENAME = "dbws.jar";
    static final String DEFAULT_MANIFEST = Attributes.Name.MANIFEST_VERSION.toString() + ": 1.0\n" + "Created-by: DBWSBuilder 1.0\n\n";
    protected DBWSPackager packager;
    protected String jarFilename = null;
    protected JarOutputStream jarOutputStream = null;
    protected File f;
    protected FileInputStream fis;
    protected byte[] buffer = new byte[1024];

    public JarArchiver() {
    }

    public JarArchiver(DBWSPackager packager) {
        this.packager = packager;
    }

    @Override
    public DBWSPackager getPackager() {
        return this.packager;
    }

    @Override
    public void setPackager(DBWSPackager packager) {
        this.packager = packager;
    }

    @Override
    public String getFilename() {
        return this.jarFilename;
    }

    @Override
    public void setFilename(String jarFilename) {
        if (!jarFilename.endsWith(".jar")) {
            jarFilename = jarFilename + ".jar";
        }
        this.jarFilename = jarFilename;
    }

    @Override
    public void archive() {
        try {
            JarOutputStream jarOutputStream = this.buildJarOutputStream();
            if (jarOutputStream != null) {
                Manifest manifest = this.buildManifest();
                if (manifest != null) {
                    ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
                    jarOutputStream.putNextEntry(e);
                    manifest.write(new BufferedOutputStream(jarOutputStream));
                    jarOutputStream.closeEntry();
                }
                this.addFilesToJarOutputStream(jarOutputStream);
                jarOutputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Manifest buildManifest() {
        Manifest manifest = null;
        try {
            new Manifest(new ByteArrayInputStream(DEFAULT_MANIFEST.getBytes("ISO-8859-1")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return manifest;
    }

    protected JarOutputStream buildJarOutputStream() {
        JarOutputStream jarOutputStream = null;
        try {
            if (this.jarFilename == null || this.jarFilename.length() == 0) {
                this.jarFilename = DEFAULT_JAR_FILENAME;
            }
            jarOutputStream = new JarOutputStream(new FileOutputStream(new File(this.packager.getStageDir(), this.jarFilename)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jarOutputStream;
    }

    protected JarEntry getSchemaJarEntry() {
        return new JarEntry("eclipselink-dbws-schema.xsd");
    }

    protected JarEntry getSWARefJarEntry() {
        return new JarEntry(Util.SWAREF_FILENAME);
    }

    protected JarEntry getOrJarEntry() {
        return new JarEntry(org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[0] + "eclipselink-dbws-or.xml");
    }

    protected JarEntry getOxJarEntry() {
        return new JarEntry(org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[0] + "eclipselink-dbws-ox.xml");
    }

    protected JarEntry getSessionsJarEntry() {
        return new JarEntry(org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[0] + this.packager.getSessionsFileName());
    }

    protected JarEntry getServiceJarEntry() {
        return new JarEntry(org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[0] + "eclipselink-dbws.xml");
    }

    protected void addFilesToJarOutputStream(JarOutputStream jarOutputStream) {
        try {
            jarOutputStream.putNextEntry(this.getSchemaJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-schema.xsd");
            this.fis = new FileInputStream(this.f);
            int read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            if (this.packager.hasAttachments()) {
                jarOutputStream.putNextEntry(this.getSWARefJarEntry());
                this.f = new File(this.packager.getStageDir(), Util.SWAREF_FILENAME);
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
            }
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-or.xml");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getOrJarEntry());
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-ox.xml");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getOxJarEntry());
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getSessionsJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-sessions.xml");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getServiceJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws.xml");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getOrProjectPathPrefix() {
        return org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[0];
    }

    @Override
    public String getOxProjectPathPrefix() {
        return org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[0];
    }

    @Override
    public String getWSDLPathPrefix() {
        return "wsdl/";
    }
}

