/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.oxm;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OXMJavaModelImpl
implements JavaModel {
    private ClassLoader classLoader;
    private Map<String, JavaClass> javaModelClasses = new HashMap<String, JavaClass>();
    private static String DEFAULT = "DEFAULT";
    private static String JAVA_LANG_OBJECT = "java.lang.Object";

    public OXMJavaModelImpl(ClassLoader loader, JavaClass[] javaClasses) {
        this.classLoader = loader;
        for (int i = 0; i < javaClasses.length; ++i) {
            this.javaModelClasses.put(javaClasses[i].getQualifiedName(), javaClasses[i]);
        }
    }

    @Override
    public JavaClass getClass(Class<?> jClass) {
        if (jClass == null) {
            return null;
        }
        String className = jClass.getCanonicalName();
        JavaClass cachedClass = this.javaModelClasses.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            Class realClass = PrivilegedAccessHelper.getClassForName((String)className);
            if (realClass != null) {
                JavaModelImpl jm = new JavaModelImpl(this.classLoader);
                JavaClassImpl jc = new JavaClassImpl(realClass, jm);
                return jc;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new OXMJavaClassImpl(jClass.getCanonicalName());
    }

    @Override
    public JavaClass getClass(String className) {
        if (className == null) {
            return null;
        }
        if (className.contains(DEFAULT)) {
            return this.getClass(JAVA_LANG_OBJECT);
        }
        JavaClass cachedClass = this.javaModelClasses.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            Class realClass = PrivilegedAccessHelper.getClassForName((String)className);
            if (realClass != null) {
                JavaModelImpl jm = new JavaModelImpl(this.classLoader);
                JavaClassImpl jc = new JavaClassImpl(realClass, jm);
                return jc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new OXMJavaClassImpl(className);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JaxbClassLoader getJaxbClassLoader() {
        ClassLoader parent = this.getClassLoader().getParent();
        if (parent instanceof JaxbClassLoader) {
            return (JaxbClassLoader)parent;
        }
        return null;
    }

    @Override
    public Annotation getAnnotation(JavaAnnotation annotation, Class<?> jClass) {
        return null;
    }
}

