/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare.nio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelConfig;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelContainerListener;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelContainerChannelActivatedEvent;
import org.eclipse.ecf.datashare.events.IChannelContainerChannelDeactivatedEvent;
import org.eclipse.ecf.datashare.events.IChannelContainerEvent;
import org.eclipse.ecf.provider.datashare.nio.ChannelData;
import org.eclipse.ecf.provider.datashare.nio.NIOChannel;
import org.eclipse.ecf.provider.datashare.nio.Util;

public abstract class NIODatashareContainer
implements IChannelContainerAdapter {
    private Thread connectionThread;
    private LinkedList pendingConnections;
    private List pendingSockets;
    private Map channels;
    private IContainer container;
    private ListenerList listenerList;

    public NIODatashareContainer(IContainer container) {
        Assert.isNotNull((Object)container, (String)"Container cannot be null");
        this.container = container;
        container.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent event) {
                if (event instanceof IContainerConnectedEvent) {
                    ID id = ((IContainerConnectedEvent)event).getTargetID();
                    NIODatashareContainer.this.fireChannelConnectedEvent(id);
                } else if (event instanceof IContainerDisconnectedEvent) {
                    ID id = ((IContainerDisconnectedEvent)event).getTargetID();
                    NIODatashareContainer.this.fireChannelDisconnectedEvent(id);
                    NIODatashareContainer.this.disconnect();
                } else if (event instanceof IContainerDisposeEvent) {
                    NIODatashareContainer.this.disconnect();
                }
            }
        });
        this.channels = new HashMap();
        this.pendingConnections = new LinkedList();
        this.pendingSockets = new ArrayList();
        this.listenerList = new ListenerList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChannelConnectedEvent(ID containerTargetId) {
        Map map = this.channels;
        synchronized (map) {
            for (NIOChannel channel : this.channels.values()) {
                channel.fireChannelConnectEvent(containerTargetId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChannelDisconnectedEvent(ID id) {
        Map map = this.channels;
        synchronized (map) {
            for (NIOChannel channel : this.channels.values()) {
                channel.fireChannelDisconnectEvent(id);
            }
        }
    }

    private void fireChannelContainerEvent(final IChannelContainerListener listener, final IChannelContainerEvent event) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                listener.handleChannelContainerEvent(event);
            }

            public void handleException(Throwable t) {
                NIODatashareContainer.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Error handling channel container event", t));
            }
        });
    }

    private void fireChannelContainerActivatedEvent(final ID channelId) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IChannelContainerListener listener = (IChannelContainerListener)listeners[i];
            this.fireChannelContainerEvent(listener, (IChannelContainerEvent)new IChannelContainerChannelActivatedEvent(){

                public ID getChannelID() {
                    return channelId;
                }

                public ID getChannelContainerID() {
                    return NIODatashareContainer.this.container.getID();
                }

                public String toString() {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("IChannelContainerChannelActivatedEvent[");
                    buffer.append("container=").append(NIODatashareContainer.this.container.getID());
                    buffer.append(",channel=").append(channelId);
                    buffer.append(']');
                    return buffer.toString();
                }
            });
            ++i;
        }
    }

    void fireChannelContainerDeactivatedEvent(final ID channelId) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IChannelContainerListener listener = (IChannelContainerListener)listeners[i];
            this.fireChannelContainerEvent(listener, (IChannelContainerEvent)new IChannelContainerChannelDeactivatedEvent(){

                public ID getChannelID() {
                    return channelId;
                }

                public ID getChannelContainerID() {
                    return NIODatashareContainer.this.container.getID();
                }

                public String toString() {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("IChannelContainerChannelDeactivatedEvent[");
                    buffer.append("container=").append(NIODatashareContainer.this.container.getID());
                    buffer.append(",channel=").append(channelId);
                    buffer.append(']');
                    return buffer.toString();
                }
            });
            ++i;
        }
    }

    protected abstract void log(IStatus var1);

    private void storeChannel(IChannel channel) {
        this.channels.put(channel.getID(), channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        if (this.connectionThread != null) {
            this.connectionThread.interrupt();
            this.connectionThread = null;
        }
        Object object = this.pendingConnections;
        synchronized (object) {
            this.pendingConnections.clear();
        }
        object = this.pendingSockets;
        synchronized (object) {
            int i = 0;
            while (i < this.pendingSockets.size()) {
                SocketChannel channel = (SocketChannel)this.pendingSockets.get(i);
                Util.closeChannel(channel);
                ++i;
            }
            this.pendingSockets.clear();
        }
        object = this.channels;
        synchronized (object) {
            for (SocketChannel channel : this.channels.values()) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable((IChannel)channel){
                    private final /* synthetic */ IChannel val$channel;
                    {
                        this.val$channel = iChannel;
                    }

                    public void run() throws Exception {
                        this.val$channel.dispose();
                    }

                    public void handleException(Throwable t) {
                        NIODatashareContainer.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Error disposing channel: " + this.val$channel, t));
                    }
                });
            }
            this.channels.clear();
        }
    }

    private void connect(ByteBuffer buffer) throws IOException {
        while (!this.pendingConnections.isEmpty()) {
            SocketAddress remote = (SocketAddress)this.pendingConnections.removeFirst();
            SocketChannel socketChannel = SocketChannel.open(remote);
            byte[] bytes = Util.serialize(this.container.getConnectedID());
            if (bytes == null) {
                Util.closeChannel(socketChannel);
                return;
            }
            socketChannel.configureBlocking(false);
            Util.write(socketChannel, buffer, bytes);
            this.pendingSockets.add(socketChannel);
        }
    }

    public void enqueue(SocketAddress address) {
        Assert.isNotNull((Object)address, (String)"Socket address cannot be null");
        if (this.connectionThread == null) {
            this.connectionThread = new Thread((Runnable)new ConnectionRunnable(), String.valueOf(this.getClass().getName()) + "Thread-" + this.container.getID().toString());
            this.connectionThread.start();
        }
        this.pendingConnections.add(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(SocketChannel socketChannel, ChannelData data) throws ClassNotFoundException, IOException {
        byte[] message = data.getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        ObjectInputStream ois = new ObjectInputStream(bais);
        ID channelId = (ID)ois.readObject();
        Map map = this.channels;
        synchronized (map) {
            IChannel channel = this.getChannel(channelId);
            if (channel == null) {
                Util.closeChannel(socketChannel);
            } else {
                ois = new ObjectInputStream(bais);
                ID peerId = (ID)ois.readObject();
                NIOChannel datashare = (NIOChannel)channel;
                datashare.put(peerId, socketChannel);
                int available = bais.available();
                if (available != 0) {
                    byte[] received = new byte[available];
                    System.arraycopy(message, message.length - available, received, 0, available);
                    datashare.processIncomingMessage(socketChannel, received);
                }
            }
        }
    }

    private void processPendingSockets(ByteBuffer buffer) throws ClassNotFoundException, IOException {
        int i = 0;
        while (i < this.pendingSockets.size()) {
            SocketChannel socketChannel = (SocketChannel)this.pendingSockets.get(i);
            buffer.clear();
            ChannelData data = Util.read(socketChannel, buffer);
            if (!data.isOpen()) {
                Util.closeChannel(socketChannel);
                this.pendingSockets.remove(i);
                --i;
            } else if (data.getData() != null) {
                try {
                    this.handshake(socketChannel, data);
                }
                finally {
                    this.pendingSockets.remove(i);
                    --i;
                }
            }
            ++i;
        }
    }

    protected abstract NIOChannel createNIOChannel(ID var1, IChannelListener var2, Map var3) throws ECFException;

    protected abstract NIOChannel createNIOChannel(IChannelConfig var1) throws ECFException;

    public final IChannel createChannel(ID channelId, IChannelListener listener, Map properties) throws ECFException {
        Assert.isNotNull((Object)channelId, (String)"Channel id cannot be null");
        NIOChannel channel = this.createNIOChannel(channelId, listener, properties);
        if (channel != null) {
            this.storeChannel(channel);
            this.fireChannelContainerActivatedEvent(channelId);
        }
        return channel;
    }

    public final IChannel createChannel(IChannelConfig newChannelConfig) throws ECFException {
        Assert.isNotNull((Object)newChannelConfig, (String)"Channel config cannot be null");
        Assert.isNotNull((Object)newChannelConfig.getID(), (String)"Channel config id cannot be null");
        NIOChannel channel = this.createNIOChannel(newChannelConfig);
        if (channel != null) {
            this.storeChannel(channel);
            this.fireChannelContainerActivatedEvent(newChannelConfig.getID());
        }
        return channel;
    }

    public void addListener(IChannelContainerListener listener) {
        this.listenerList.add((Object)listener);
    }

    public IChannel getChannel(ID channelId) {
        Assert.isNotNull((Object)channelId, (String)"Channel id cannot be null");
        return (IChannel)this.channels.get(channelId);
    }

    public boolean removeChannel(ID channelId) {
        IChannel channel = (IChannel)this.channels.remove(channelId);
        if (channel == null) {
            return false;
        }
        channel.dispose();
        return true;
    }

    public void removeListener(IChannelContainerListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter == IContainer.class) {
            return this.container;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[parentContainer=").append(this.container).append(']');
        return buffer.toString();
    }

    private class ConnectionRunnable
    implements Runnable {
        private ConnectionRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (true) {
                try {
                    while (true) {
                        buffer.clear();
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        LinkedList linkedList = NIODatashareContainer.this.pendingConnections;
                        synchronized (linkedList) {
                            if (!NIODatashareContainer.this.pendingConnections.isEmpty()) {
                                NIODatashareContainer.this.connect(buffer);
                            }
                        }
                        NIODatashareContainer.this.processPendingSockets(buffer);
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    return;
                }
                catch (ClassNotFoundException e) {
                    NIODatashareContainer.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Could not deserialize", (Throwable)e));
                    continue;
                }
                catch (IOException e) {
                    NIODatashareContainer.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "An IO error occurred", (Throwable)e));
                    continue;
                }
                catch (RuntimeException e) {
                    NIODatashareContainer.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "A runtime error occurred", (Throwable)e));
                    continue;
                }
                break;
            }
        }
    }
}

