/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.datashare;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelConfig;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.internal.provider.irc.Activator;
import org.eclipse.ecf.internal.provider.irc.container.IRCRootContainer;
import org.eclipse.ecf.internal.provider.irc.datashare.IIRCDatashareContainer;
import org.eclipse.ecf.internal.provider.irc.datashare.IRCDatashareChannel;
import org.eclipse.ecf.provider.datashare.nio.NIOChannel;
import org.eclipse.ecf.provider.datashare.nio.NIODatashareContainer;

public class IRCDatashareContainer
extends NIODatashareContainer
implements IIRCDatashareContainer {
    private List channels = new ArrayList();
    private IRCRootContainer container;

    public IRCDatashareContainer(IRCRootContainer container) {
        super((IContainer)container);
        this.container = container;
        container.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent event) {
                if (event instanceof IContainerDisconnectedEvent || event instanceof IContainerDisposeEvent) {
                    IRCDatashareContainer.this.setIP(null);
                    IRCDatashareContainer.this.channels.clear();
                }
            }
        });
    }

    protected void log(IStatus status) {
        Activator.getDefault().log(status);
    }

    @Override
    public void setIP(String ip) {
        int i = 0;
        while (i < this.channels.size()) {
            IRCDatashareChannel channel = (IRCDatashareChannel)((Object)this.channels.get(i));
            channel.setIP(ip);
            ++i;
        }
    }

    protected NIOChannel createNIOChannel(ID channelId, IChannelListener listener, Map properties) throws ECFException {
        Assert.isNotNull((Object)channelId, (String)"Channel id cannot be null");
        IRCDatashareChannel channel = new IRCDatashareChannel(this, this.container.getConnectNamespace(), this.container.getConnectedID(), this.container.getChatRoomMessageSender(), channelId, listener);
        this.channels.add(channel);
        return channel;
    }

    protected NIOChannel createNIOChannel(IChannelConfig newChannelConfig) throws ECFException {
        Assert.isNotNull((Object)newChannelConfig, (String)"Channel config cannot be null");
        return this.createNIOChannel(newChannelConfig.getID(), newChannelConfig.getListener(), newChannelConfig.getProperties());
    }

    public Namespace getChannelNamespace() {
        return IDFactory.getDefault().getNamespaceByName(StringID.class.getName());
    }
}

