/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.WriterListener;

public class ConsoleDebugger
implements SmackDebugger {
    public static boolean printInterpreted = false;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("hh:mm:ss aaa");
    private Connection connection = null;
    private PacketListener listener = null;
    private ConnectionListener connListener = null;
    private Writer writer;
    private Reader reader;
    private ReaderListener readerListener;
    private WriterListener writerListener;

    public ConsoleDebugger(Connection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.writer = writer;
        this.reader = reader;
        this.createDebug();
    }

    private void createDebug() {
        ObservableReader debugReader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){

            public void read(String str) {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " RCV  (" + ConsoleDebugger.this.connection.hashCode() + "): " + str);
            }
        };
        debugReader.addReaderListener(this.readerListener);
        ObservableWriter debugWriter = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){

            public void write(String str) {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " SENT (" + ConsoleDebugger.this.connection.hashCode() + "): " + str);
            }
        };
        debugWriter.addWriterListener(this.writerListener);
        this.reader = debugReader;
        this.writer = debugWriter;
        this.listener = new PacketListener(){

            public void processPacket(Packet packet) {
                if (printInterpreted) {
                    System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " RCV PKT (" + ConsoleDebugger.this.connection.hashCode() + "): " + packet.toXML());
                }
            }
        };
        this.connListener = new ConnectionListener(){

            public void connectionClosed() {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " Connection closed (" + ConsoleDebugger.this.connection.hashCode() + ")");
            }

            public void connectionClosedOnError(Exception e) {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " Connection closed due to an exception (" + ConsoleDebugger.this.connection.hashCode() + ")");
                e.printStackTrace();
            }

            public void reconnectionFailed(Exception e) {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " Reconnection failed due to an exception (" + ConsoleDebugger.this.connection.hashCode() + ")");
                e.printStackTrace();
            }

            public void reconnectionSuccessful() {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " Connection reconnected (" + ConsoleDebugger.this.connection.hashCode() + ")");
            }

            public void reconnectingIn(int seconds) {
                System.out.println(String.valueOf(ConsoleDebugger.this.dateFormatter.format(new Date())) + " Connection (" + ConsoleDebugger.this.connection.hashCode() + ") will reconnect in " + seconds);
            }
        };
    }

    public Reader newConnectionReader(Reader newReader) {
        ((ObservableReader)this.reader).removeReaderListener(this.readerListener);
        ObservableReader debugReader = new ObservableReader(newReader);
        debugReader.addReaderListener(this.readerListener);
        this.reader = debugReader;
        return this.reader;
    }

    public Writer newConnectionWriter(Writer newWriter) {
        ((ObservableWriter)this.writer).removeWriterListener(this.writerListener);
        ObservableWriter debugWriter = new ObservableWriter(newWriter);
        debugWriter.addWriterListener(this.writerListener);
        this.writer = debugWriter;
        return this.writer;
    }

    public void userHasLogged(String user) {
        boolean isAnonymous = "".equals(StringUtils.parseName(user));
        String title = "User logged (" + this.connection.hashCode() + "): " + (isAnonymous ? "" : StringUtils.parseBareAddress(user)) + "@" + this.connection.getServiceName() + ":" + this.connection.getPort();
        title = String.valueOf(title) + "/" + StringUtils.parseResource(user);
        System.out.println(title);
        this.connection.addConnectionListener(this.connListener);
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public PacketListener getReaderListener() {
        return this.listener;
    }

    public PacketListener getWriterListener() {
        return null;
    }
}

