/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.ui;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.presence.service.IPresenceService;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ecf.presence.ui";
    public static final String CONTACTS_IMAGE = "contacts";
    public static final String COLLABORATION_IMAGE = "collaboration";
    private static Activator plugin;
    private ServiceTracker tracker;
    private ServiceTracker extensionRegistryTracker = null;
    private ServiceTracker containerManagerTracker = null;
    private BundleContext bundleContext;

    public IPresenceService[] getPresenceServices() {
        ServiceReference[] references = this.tracker.getServiceReferences();
        if (references == null) {
            return new IPresenceService[0];
        }
        int length = references.length;
        IPresenceService[] services = new IPresenceService[length];
        int i = 0;
        while (i < length) {
            services[i] = (IPresenceService)this.tracker.getService(references[i]);
            ++i;
        }
        return services;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.bundleContext = context;
        this.tracker = new ServiceTracker(context, IPresenceService.class.getName(), null);
        this.tracker.open();
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = super.createImageRegistry();
        registry.put(CONTACTS_IMAGE, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/contacts.gif").createImage());
        registry.put(COLLABORATION_IMAGE, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/collaboration.gif").createImage());
        return registry;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        this.bundleContext = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IExtensionRegistry getExtensionRegistry() {
        if (this.extensionRegistryTracker == null) {
            this.extensionRegistryTracker = new ServiceTracker(this.bundleContext, IExtensionRegistry.class.getName(), null);
            this.extensionRegistryTracker.open();
        }
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(this.bundleContext, IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

