/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.start;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.start.ConnectionDetails;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class AccountStart {
    private static final String SAVED = "saved-connections";
    private static final int BACKING_STORE_SAVE_ERROR = 1001;
    private static final int BACKING_STORE_LOAD_ERROR = 1002;
    private Map connectionDetails = new HashMap();

    public ConnectionDetails addConnectionDetails(ConnectionDetails cd) {
        String targetURI = this.normalizeURI(cd.getTargetURI());
        return this.connectionDetails.put(targetURI, cd);
    }

    private String normalizeURI(String uri) {
        return uri.replace('/', '.');
    }

    public void removeConnectionDetails(ConnectionDetails cd) {
        try {
            IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.ecf.example.collab");
            Preferences connections = preferences.node(SAVED);
            String[] targets = connections.childrenNames();
            int i = 0;
            while (i < targets.length) {
                String target = targets[i];
                Preferences node = connections.node(target);
                String cdTarget = this.normalizeURI(cd.getTargetURI());
                if (node != null && target != null && target.equals(cdTarget)) {
                    node.removeNode();
                }
                ++i;
            }
            connections.flush();
        }
        catch (BackingStoreException e) {
            ClientPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab", 1002, Messages.AccountStart_EXCEPTION_LOADING_CONNECTION_DETAILS, (Throwable)e));
        }
    }

    public Collection getConnectionDetails() {
        return this.connectionDetails.values();
    }

    public void saveConnectionDetailsToPreferenceStore() {
        IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.ecf.example.collab");
        Preferences connections = preferences.node(SAVED);
        Iterator i = this.connectionDetails.keySet().iterator();
        while (i.hasNext()) {
            String target = (String)i.next();
            ConnectionDetails details = (ConnectionDetails)this.connectionDetails.get(target);
            Preferences p = connections.node(target);
            p.put("containerType", details.getContainerType());
            p.put("targetURI", details.getTargetURI());
            p.put("nickname", details.getNickname());
            p.put("password", details.getPassword());
        }
        try {
            connections.flush();
        }
        catch (BackingStoreException e) {
            ClientPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab", 1001, Messages.AccountStart_EXCEPTION_SAVING_CONNECTION_DETAILS, (Throwable)e));
        }
    }

    public void loadConnectionDetailsFromPreferenceStore() {
        try {
            IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.ecf.example.collab");
            Preferences connections = preferences.node(SAVED);
            String[] targets = connections.childrenNames();
            int i = 0;
            while (i < targets.length) {
                String target = targets[i];
                Preferences node = connections.node(target);
                if (node != null) {
                    this.addConnectionDetails(new ConnectionDetails(node.get("containerType", ""), node.get("targetURI", ""), node.get("nickname", ""), node.get("password", "")));
                }
                ++i;
            }
        }
        catch (BackingStoreException e) {
            ClientPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab", 1002, Messages.AccountStart_EXCEPTION_LOADING_CONNECTION_DETAILS, (Throwable)e));
        }
    }
}

