/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RosterGroup {
    private String name;
    private Connection connection;
    private final List<RosterEntry> entries;

    RosterGroup(String name, Connection connection) {
        this.name = name;
        this.connection = connection;
        this.entries = new ArrayList<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            for (RosterEntry entry : this.entries) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.removeGroupName(this.name);
                item.addGroupName(name);
                packet.addRosterItem(item);
                this.connection.sendPacket(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RosterEntry> getEntries() {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<RosterEntry>(this.entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(String user) {
        if (user == null) {
            return null;
        }
        user = StringUtils.parseBareAddress(user);
        String userLowerCase = user.toLowerCase();
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            for (RosterEntry entry : this.entries) {
                if (!entry.getUser().equals(userLowerCase)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RosterEntry entry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return this.entries.contains(entry);
        }
    }

    public boolean contains(String user) {
        return this.getEntry(user) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry entry) throws XMPPException {
        PacketCollector collector = null;
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            if (!this.entries.contains(entry)) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.addGroupName(this.getName());
                packet.addRosterItem(item);
                collector = this.connection.createPacketCollector(new PacketIDFilter(packet.getPacketID()));
                this.connection.sendPacket(packet);
            }
        }
        if (collector != null) {
            IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            collector.cancel();
            if (response == null) {
                throw new XMPPException("No response from the server.");
            }
            if (response.getType() == IQ.Type.ERROR) {
                throw new XMPPException(response.getError());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry entry) throws XMPPException {
        PacketCollector collector = null;
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            if (this.entries.contains(entry)) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.removeGroupName(this.getName());
                packet.addRosterItem(item);
                collector = this.connection.createPacketCollector(new PacketIDFilter(packet.getPacketID()));
                this.connection.sendPacket(packet);
            }
        }
        if (collector != null) {
            IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            collector.cancel();
            if (response == null) {
                throw new XMPPException("No response from the server.");
            }
            if (response.getType() == IQ.Type.ERROR) {
                throw new XMPPException(response.getError());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryLocal(RosterEntry entry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            this.entries.remove(entry);
            this.entries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryLocal(RosterEntry entry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            if (this.entries.contains(entry)) {
                this.entries.remove(entry);
            }
        }
    }
}

