/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.internal.commons.xmlrpc.CommonXmlRpcClient;
import org.eclipse.mylyn.internal.commons.xmlrpc.Multicall;
import org.eclipse.mylyn.internal.commons.xmlrpc.MulticallResult;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcClientRequest;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcHttpException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcIllegalContentTypeException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcLoginException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcNoSuchMethodException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcPermissionDeniedException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcProxyAuthenticationException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcRemoteException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcSslCertificateException;

public abstract class XmlRpcOperation<T> {
    private static final Pattern RPC_METHOD_NOT_FOUND_PATTERN = Pattern.compile("No such handler: ");
    protected static final int XML_FAULT_GENERAL_ERROR = 1;
    protected static final int XML_FAULT_PERMISSION_DENIED = 403;
    private final CommonXmlRpcClient client;

    public XmlRpcOperation(CommonXmlRpcClient client) {
        this.client = client;
    }

    protected Object call(IProgressMonitor monitor, String method, Object ... parameters) throws XmlRpcException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        XmlRpcException lastException = null;
        int attempt = 0;
        while (attempt < 3) {
            try {
                return this.executeCall(monitor, method, parameters);
            }
            catch (XmlRpcLoginException | XmlRpcPermissionDeniedException e) {
                try {
                    this.client.getLocation().requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                }
                catch (UnsupportedRequestException ignored) {
                    throw e;
                }
                lastException = e;
            }
            catch (XmlRpcProxyAuthenticationException e) {
                try {
                    this.client.getLocation().requestCredentials(AuthenticationType.PROXY, null, monitor);
                }
                catch (UnsupportedRequestException ignored) {
                    throw e;
                }
                lastException = e;
            }
            catch (XmlRpcSslCertificateException e) {
                try {
                    this.client.getLocation().requestCredentials(AuthenticationType.CERTIFICATE, null, monitor);
                }
                catch (UnsupportedRequestException ignored) {
                    throw e;
                }
                lastException = e;
            }
            ++attempt;
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    private void checkForException(Object result) throws NumberFormatException, XmlRpcException {
        Object object = result;
        if (object instanceof Map) {
            void exceptionData;
            Map map = (Map)object;
            Map cfr_ignored_0 = (Map)object;
            if (exceptionData.containsKey("faultCode") && exceptionData.containsKey("faultString")) {
                throw new XmlRpcException(Integer.parseInt(exceptionData.get("faultCode").toString()), (String)exceptionData.get("faultString"));
            }
            if (exceptionData.containsKey("title")) {
                Object message = (String)exceptionData.get("title");
                String detail = (String)exceptionData.get("_message");
                if (detail != null) {
                    message = (String)message + ": " + detail;
                }
                throw new XmlRpcException(1, (String)message);
            }
        }
    }

    protected boolean credentialsValid(AuthenticationCredentials credentials) {
        return credentials != null;
    }

    public abstract T execute() throws XmlRpcException;

    protected Object executeCall(IProgressMonitor monitor, String method, Object ... parameters) throws XmlRpcException {
        try {
            if (CommonXmlRpcClient.DEBUG_XMLRPC) {
                System.err.println("Calling " + this.client.getLocation().getUrl() + ": " + method + " " + CoreUtil.toString((Object)parameters));
            }
            AuthenticationCredentials credentials = this.client.updateCredentials();
            XmlRpcClientRequest request = new XmlRpcClientRequest((XmlRpcRequestConfig)this.client.getClient().getClientConfig(), this.getXmlRpcUrl(credentials), method, parameters, monitor);
            return this.client.getClient().execute((XmlRpcRequest)request);
        }
        catch (XmlRpcHttpException e) {
            this.handleAuthenticationException(e.code, e.getAuthScheme());
            throw e;
        }
        catch (OperationCanceledException | XmlRpcIllegalContentTypeException e) {
            throw e;
        }
        catch (XmlRpcException e) {
            if ("XML_RPC privileges are required to perform this operation".equals(e.getMessage()) || e.code == 403) {
                this.handleAuthenticationException(403, null);
                throw new XmlRpcRemoteException(e);
            }
            if (this.isNoSuchMethodException(e)) {
                throw new XmlRpcNoSuchMethodException(e);
            }
            throw new XmlRpcRemoteException(e);
        }
        catch (Exception e) {
            throw new XmlRpcException("Unexpected exception", (Throwable)e);
        }
    }

    protected final CommonXmlRpcClient getClient() {
        return this.client;
    }

    protected Object getMultiCallResult(Object item) {
        return ((Object[])item)[0];
    }

    protected URL getXmlRpcUrl(AuthenticationCredentials credentials) {
        try {
            return new URL(this.client.getLocation().getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Encoding of URL failed", e);
        }
    }

    protected boolean handleAuthenticationException(int code, AuthScheme authScheme) throws XmlRpcException {
        if (code == 401) {
            if (CommonXmlRpcClient.DEBUG_AUTH) {
                System.err.println(this.client.getLocation().getUrl() + ": Unauthorized (" + code + ")");
            }
            this.client.digestScheme = null;
            XmlRpcLoginException exception = new XmlRpcLoginException();
            exception.setNtlmAuthRequested(authScheme instanceof NTLMScheme);
            throw exception;
        }
        if (code == 403) {
            if (CommonXmlRpcClient.DEBUG_AUTH) {
                System.err.println(this.client.getLocation().getUrl() + ": Forbidden (" + code + ")");
            }
            this.client.digestScheme = null;
            throw new XmlRpcPermissionDeniedException();
        }
        if (code == 407) {
            if (CommonXmlRpcClient.DEBUG_AUTH) {
                System.err.println(this.client.getLocation().getUrl() + ": Proxy authentication required (" + code + ")");
            }
            throw new XmlRpcProxyAuthenticationException();
        }
        return false;
    }

    protected boolean isNoSuchMethodException(XmlRpcException e) {
        return RPC_METHOD_NOT_FOUND_PATTERN.matcher(e.getMessage()).find();
    }

    protected MulticallResult call(IProgressMonitor monitor, Multicall call) throws XmlRpcException {
        Object[] response;
        Object[] objectArray = response = (Object[])this.call(monitor, "system.multicall", new Object[]{call.getCalls()});
        int n = response.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.checkForException(item);
            ++n2;
        }
        return new MulticallResult(response);
    }
}

