/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property.editor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.xml.model.property.IExpressionPropertyEditor;
import org.eclipse.wb.internal.core.xml.model.property.editor.StaticFieldPropertyEditorGetExpression;

public final class StaticFieldPropertyEditor
extends AbstractComboPropertyEditor
implements IConfigurablePropertyObject,
IExpressionPropertyEditor,
IClipboardSourceProvider {
    private Class<?> m_class;
    private String[] m_names;
    private String[] m_titles;
    private Object[] m_values;

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            int i = 0;
            while (i < this.m_values.length) {
                Object fieldValue = this.m_values[i];
                if (ObjectUtils.equals((Object)fieldValue, (Object)value)) {
                    return this.m_titles[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String getValueExpression(GenericProperty property, Object value) throws Exception {
        if (value != Property.UNKNOWN_VALUE) {
            int i = 0;
            while (i < this.m_values.length) {
                if (ObjectUtils.equals((Object)this.m_values[i], (Object)value)) {
                    return this.getExpression(property, i);
                }
                ++i;
            }
        }
        return null;
    }

    private String getExpression(GenericProperty property, int index) throws Exception {
        String fieldName = this.m_names[index];
        if (fieldName == null) {
            return null;
        }
        String[] expression = new String[1];
        ((StaticFieldPropertyEditorGetExpression)property.getObject().getBroadcast(StaticFieldPropertyEditorGetExpression.class)).invoke(this.m_class, fieldName, expression);
        Assert.isNotNull2((Object)expression[0], (String)"Can not resolve {0} {1}", (Object[])new Object[]{this.m_class, fieldName});
        return expression[0];
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        Object value = property.getValue();
        return this.getValueExpression(property, value);
    }

    protected void addItems(Property property, CCombo3 combo) throws Exception {
        String[] stringArray = this.m_titles;
        int n = this.m_titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            combo.add(title);
            ++n2;
        }
    }

    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    /*
     * WARNING - void declaration
     */
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        Property property2 = property;
        if (property2 instanceof GenericProperty) {
            void genericProperty;
            GenericProperty genericProperty2 = (GenericProperty)property2;
            GenericProperty cfr_ignored_0 = (GenericProperty)property2;
            String expression = this.getExpression((GenericProperty)genericProperty, index);
            Object value = this.m_values[index];
            genericProperty.setExpression(expression, value);
        }
    }

    public void configure(Class<?> clazz, String[] fieldDescriptions) throws Exception {
        this.m_class = clazz;
        this.initialize(fieldDescriptions);
    }

    @Override
    public void configure(EditorContext context, Map<String, Object> parameters) throws Exception {
        String[] fieldDescriptions;
        String classBinaryName = (String)parameters.get("class");
        if (classBinaryName == null) {
            throw new DesignerException(5003, new String[]{"No class."});
        }
        this.m_class = context.getClassLoader().loadClass(classBinaryName);
        if (parameters.containsKey("fields")) {
            Object fieldsObject = parameters.get("fields");
            if (fieldsObject instanceof List) {
                List fieldDescriptionList = (List)fieldsObject;
                fieldDescriptions = fieldDescriptionList.toArray(new String[fieldDescriptionList.size()]);
            } else {
                fieldDescriptions = StringUtils.split((String)((String)fieldsObject));
            }
        } else {
            throw new DesignerException(5003, new String[]{"No fields."});
        }
        this.initialize(fieldDescriptions);
    }

    private void initialize(String[] fieldDescriptions) throws Exception {
        fieldDescriptions = StaticFieldPropertyEditor.cleanUpFieldDescriptions(this.m_class, fieldDescriptions);
        int count = fieldDescriptions.length;
        this.m_names = new String[count];
        this.m_titles = new String[count];
        this.m_values = new Object[count];
        int i = 0;
        while (i < count) {
            String fieldDescription = fieldDescriptions[i];
            if ("*remove".equals(fieldDescription)) {
                this.m_titles[i] = "";
            } else {
                this.m_names[i] = StaticFieldPropertyEditor.getFieldName(fieldDescription);
                this.m_titles[i] = StaticFieldPropertyEditor.getFieldTitle(fieldDescription);
                Field field = this.m_class.getField(this.m_names[i]);
                Assert.isTrue((boolean)Modifier.isStatic(field.getModifiers()), (String)"Field %s is not static.", (Object[])new Object[]{field});
                this.m_values[i] = field.get(null);
            }
            ++i;
        }
    }

    private static String[] cleanUpFieldDescriptions(Class<?> m_class, String[] fieldDescriptions) throws Exception {
        ArrayList<String> newFieldDescriptions = new ArrayList<String>();
        String[] stringArray = fieldDescriptions;
        int n = fieldDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String fieldDescription = stringArray[n2];
                if ("*remove".equals(fieldDescription)) {
                    newFieldDescriptions.add(fieldDescription);
                } else {
                    String name = StaticFieldPropertyEditor.getFieldName(fieldDescription);
                    try {
                        m_class.getField(name);
                    }
                    catch (NoSuchFieldException e) {
                        break block5;
                    }
                    newFieldDescriptions.add(fieldDescription);
                }
            }
            ++n2;
        }
        return newFieldDescriptions.toArray(new String[newFieldDescriptions.size()]);
    }

    private static String getFieldName(String fieldDescription) {
        if (!fieldDescription.contains(":")) {
            return fieldDescription;
        }
        return StaticFieldPropertyEditor.getTwoParts(fieldDescription)[0];
    }

    private static String getFieldTitle(String fieldDescription) {
        if (!fieldDescription.contains(":")) {
            return fieldDescription;
        }
        return StaticFieldPropertyEditor.getTwoParts(fieldDescription)[1];
    }

    private static String[] getTwoParts(String fieldDescription) {
        String[] parts = StringUtils.split((String)fieldDescription, (String)":");
        String message = "Exactly one ':' expected in description name:title, but found " + fieldDescription;
        Assert.equals((int)2, (int)parts.length, (String)message);
        return parts;
    }
}

