/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.digester3.AbstractObjectCreationFactory;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.apache.commons.digester3.Rule;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.ClassResourceInfo;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.CreationAttributeDescription;
import org.eclipse.wb.internal.core.xml.model.description.CreationDescription;
import org.eclipse.wb.internal.core.xml.model.description.IDescriptionProcessor;
import org.eclipse.wb.internal.core.xml.model.description.IDescriptionRulesProvider;
import org.eclipse.wb.internal.core.xml.model.description.rules.ConfigurableObjectListParameterRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.ConfigurableObjectParameterRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.CreatePropertiesFieldRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.CreatePropertiesPropertyDescriptorRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.ModelClassRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.MorphingNoInheritRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.MorphingTargetRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertiesCategoryRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertiesNoDefaultValueRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertyAccessRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertyCategoryRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertyDefaultRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertyEditorRule;
import org.eclipse.wb.internal.core.xml.model.description.rules.PropertyTagRule;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public final class ComponentDescriptionHelper {
    private static final ClassMap<ComponentDescription> m_getDescription_Class = ClassMap.create();

    public static ComponentDescription getDescription(EditorContext context, String componentClassName) throws Exception {
        Class<?> componentClass = context.getClassLoader().loadClass(componentClassName);
        return ComponentDescriptionHelper.getDescription(context, componentClass);
    }

    public static ComponentDescription getDescription(EditorContext context, Class<?> componentClass) throws Exception {
        ComponentDescription description = (ComponentDescription)m_getDescription_Class.get(componentClass);
        if (description == null) {
            description = ComponentDescriptionHelper.getDescription0(context, componentClass);
            m_getDescription_Class.put(componentClass, (Object)description);
        }
        return description;
    }

    private static ComponentDescription getDescription0(EditorContext context, Class<?> componentClass) throws Exception {
        try {
            return ComponentDescriptionHelper.getDescriptionEx(context, componentClass);
        }
        catch (Throwable e) {
            throw new DesignerException(5001, e, new String[]{componentClass.getName()});
        }
    }

    private static ComponentDescription getDescriptionEx(EditorContext context, Class<?> componentClass) throws Exception {
        ComponentDescription componentDescription = new ComponentDescription(componentClass);
        LinkedList descriptionInfos = new LinkedList();
        DescriptionHelper.addDescriptionResources(descriptionInfos, (ILoadingContext)context.getLoadingContext(), componentClass);
        Assert.isTrueException((!descriptionInfos.isEmpty() ? 1 : 0) != 0, (int)5000, (Object[])new Object[]{componentClass.getName()});
        Digester digester = new Digester();
        digester.setLogger((Log)new NoOpLog());
        ComponentDescriptionHelper.addRules(digester, context, componentClass);
        for (ClassResourceInfo descriptionInfo : descriptionInfos) {
            ResourceInfo resourceInfo = descriptionInfo.resource;
            digester.push((Object)componentDescription);
            InputStream is = resourceInfo.getURL().openStream();
            try {
                digester.parse(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            if (descriptionInfo.clazz == componentClass) {
                ComponentDescriptionHelper.setDescriptionWithInnerTags(componentDescription, resourceInfo);
                continue;
            }
            componentDescription.clearCreations();
            componentDescription.setDescription(null);
        }
        if (componentDescription.getToolkit() == null) {
            int i = descriptionInfos.size() - 1;
            while (i >= 0) {
                ClassResourceInfo descriptionInfo = (ClassResourceInfo)descriptionInfos.get(i);
                ToolkitDescription toolkit = descriptionInfo.resource.getToolkit();
                if (toolkit != null) {
                    componentDescription.setToolkit(toolkit);
                    break;
                }
                --i;
            }
        }
        if (ComponentDescriptionHelper.shouldCachePresentation((ClassResourceInfo)descriptionInfos.getLast(), componentClass)) {
            componentDescription.setPresentationCached(true);
        }
        ComponentDescriptionHelper.setIcon(context, componentDescription, componentClass);
        ComponentDescriptionHelper.useDescriptionProcessors(context, componentDescription);
        componentDescription.postProcess();
        return componentDescription;
    }

    private static void setIcon(EditorContext context, ComponentDescription componentDescription, Class<?> currentClass) throws Exception {
        if (currentClass != null) {
            ImageDescriptor icon;
            if (componentDescription.getIcon() == null && (icon = DescriptionHelper.getIcon((ILoadingContext)context.getLoadingContext(), currentClass)) != null) {
                componentDescription.setIcon(icon);
                return;
            }
            if (componentDescription.getIcon() == null) {
                ComponentDescriptionHelper.setIcon(context, componentDescription, currentClass.getSuperclass());
            }
        }
    }

    private static void useDescriptionProcessors(EditorContext context, ComponentDescription componentDescription) throws Exception {
        List processors = ExternalFactoriesHelper.getElementsInstances(IDescriptionProcessor.class, (String)"org.eclipse.wb.core.xml.descriptionProcessors", (String)"processor");
        for (IDescriptionProcessor processor : processors) {
            processor.process(context, componentDescription);
        }
    }

    private static void setDescriptionWithInnerTags(ComponentDescription componentDescription, ResourceInfo resourceInfo) throws Exception {
        InputStream stream = resourceInfo.getURL().openStream();
        String string = IOUtils2.readString((InputStream)stream);
        String description = StringUtils.substringBetween((String)string, (String)"<description>", (String)"</description>");
        if (description != null) {
            componentDescription.setDescription(description);
        }
    }

    private static boolean shouldCachePresentation(ClassResourceInfo descriptionInfo, Class<?> componentClass) throws Exception {
        Bundle bundle;
        if (descriptionInfo.clazz == componentClass && (bundle = descriptionInfo.resource.getBundle()) != null) {
            return bundle.getEntry("wbp-meta/.wbp-cache-presentations") != null;
        }
        return false;
    }

    private static void addRules(Digester digester, EditorContext context, Class<?> componentClass) {
        digester.addRule("component/x-model", (Rule)new ModelClassRule());
        ComponentDescriptionHelper.addPropertiesRules(digester, context);
        ComponentDescriptionHelper.addCreationRules(digester, context, "component/creation", "addCreation");
        String pattern = "component/morphTargets/morphTarget";
        digester.addRule(pattern, (Rule)new MorphingTargetRule(context.getClassLoader()));
        pattern = "component/morphTargets/noInherit";
        digester.addRule(pattern, (Rule)new MorphingNoInheritRule());
        pattern = "component/parameters/parameter";
        digester.addCallMethod(pattern, "addParameter", 2);
        digester.addCallParam(pattern, 0, "name");
        digester.addCallParam(pattern, 1);
        List providers = ExternalFactoriesHelper.getElementsInstances(IDescriptionRulesProvider.class, (String)"org.eclipse.wb.core.xml.descriptionRulesProviders", (String)"provider");
        for (IDescriptionRulesProvider provider : providers) {
            provider.addRules(digester, context, componentClass);
        }
    }

    private static void addPropertiesRules(Digester digester, EditorContext context) {
        digester.addRule("component/standard-bean-properties", (Rule)new CreatePropertiesPropertyDescriptorRule());
        digester.addRule("component/public-field-properties", (Rule)new CreatePropertiesFieldRule());
        digester.addRule("component/properties-preferred", (Rule)new PropertiesCategoryRule(PropertyCategory.PREFERRED));
        digester.addRule("component/properties-normal", (Rule)new PropertiesCategoryRule(PropertyCategory.NORMAL));
        digester.addRule("component/properties-advanced", (Rule)new PropertiesCategoryRule(PropertyCategory.ADVANCED));
        digester.addRule("component/properties-hidden", (Rule)new PropertiesCategoryRule(PropertyCategory.HIDDEN));
        digester.addRule("component/properties-noDefaultValue", (Rule)new PropertiesNoDefaultValueRule());
        digester.addRule("component/property-tag", (Rule)new PropertyTagRule());
        String propertyAccessPattern = "component/property";
        digester.addRule(propertyAccessPattern, (Rule)new PropertyAccessRule());
        ComponentDescriptionHelper.addPropertyConfigurationRules(digester, context, propertyAccessPattern);
    }

    private static void addPropertyConfigurationRules(Digester digester, EditorContext context, String propertyAccessPattern) {
        String pattern = propertyAccessPattern + "/category";
        digester.addRule(pattern, (Rule)new PropertyCategoryRule());
        pattern = propertyAccessPattern + "/editor";
        digester.addRule(pattern, (Rule)new PropertyEditorRule(context));
        ComponentDescriptionHelper.addConfigurableObjectParametersRules(digester, pattern);
        pattern = propertyAccessPattern + "/defaultValue";
        ClassLoader classLoader = context.getClassLoader();
        digester.addRule(pattern, (Rule)new PropertyDefaultRule(classLoader));
        pattern = propertyAccessPattern + "/tag";
        digester.addRule(pattern, (Rule)new PropertyTagRule());
    }

    public static void addConfigurableObjectParametersRules(Digester digester, String pattern) {
        digester.addRule(pattern + "/parameter", (Rule)new ConfigurableObjectParameterRule());
        digester.addRule(pattern + "/parameter-list", (Rule)new ConfigurableObjectListParameterRule());
    }

    private static void addCreationRules(Digester digester, final EditorContext context, String basePattern, String setCreationMethod) {
        digester.addFactoryCreate(basePattern, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
                String id = attributes.getValue("id");
                String name = attributes.getValue("name");
                CreationDescription creation = new CreationDescription(componentDescription, id, name);
                if (id != null) {
                    Class<?> componentClass = componentDescription.getComponentClass();
                    String suffix = "_" + id;
                    ImageDescriptor icon = ComponentDescriptionHelper.getIcon(context, componentClass, suffix);
                    creation.setIcon(icon);
                }
                return creation;
            }
        });
        digester.addSetNext(basePattern, setCreationMethod);
        String pattern = basePattern + "/description";
        digester.addCallMethod(pattern, "setDescription", 1);
        digester.addCallParam(pattern, 0);
        pattern = basePattern + "/x-attribute";
        digester.addFactoryCreate(pattern, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                String space = attributes.getValue("ns");
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                return new CreationAttributeDescription(space, name, value);
            }
        });
        digester.addSetNext(pattern, "addAttribute");
        pattern = basePattern + "/x-content";
        digester.addCallMethod(pattern, "setContent", 1);
        digester.addCallParam(pattern, 0);
        pattern = basePattern + "/parameter";
        digester.addCallMethod(pattern, "addParameter", 2);
        digester.addCallParam(pattern, 0, "name");
        digester.addCallParam(pattern, 1);
    }

    public static ImageDescriptor getIcon(EditorContext context, Class<?> componentClass, String suffix) throws Exception {
        ILoadingContext loadingContext = context.getLoadingContext();
        return DescriptionHelper.getIcon((ILoadingContext)loadingContext, componentClass, (String)suffix);
    }
}

