/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.xml.model.description.CreationDescription;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;

public final class ComponentDescription
extends AbstractDescription
implements IComponentDescription {
    private final Class<?> m_componentClass;
    private ToolkitDescription m_toolkit;
    private Class<?> m_modelClass;
    private ImageDescriptor m_icon;
    private String m_description;
    private boolean m_presentationCached;
    private final List<GenericPropertyDescription> m_properties = new ArrayList<GenericPropertyDescription>();
    private final Map<String, GenericPropertyDescription> m_idToProperty = new HashMap<String, GenericPropertyDescription>();
    private final Map<String, CreationDescription> m_creations = new HashMap<String, CreationDescription>();
    private final Map<String, String> m_parameters = new TreeMap<String, String>();
    private final List<MorphingTargetDescription> m_morphingTargets = new ArrayList<MorphingTargetDescription>();

    public ComponentDescription(Class<?> componentClass) {
        this.m_componentClass = componentClass;
    }

    public Class<?> getComponentClass() {
        return this.m_componentClass;
    }

    public ToolkitDescription getToolkit() {
        return this.m_toolkit;
    }

    public void setToolkit(ToolkitDescription toolkit) {
        this.m_toolkit = toolkit;
    }

    public Class<?> getModelClass() {
        return this.m_modelClass;
    }

    public void setModelClass(Class<?> modelClass) {
        this.m_modelClass = modelClass;
    }

    public ImageDescriptor getIcon() {
        return this.m_icon;
    }

    public void setIcon(ImageDescriptor icon) {
        this.m_icon = icon;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.m_description = StringUtilities.normalizeWhitespaces((String)description);
            this.m_description = StringUtils.replace((String)this.m_description, (String)"\\n", (String)"\n");
        } else {
            this.m_description = this.m_componentClass.getName();
        }
    }

    public boolean isPresentationCached() {
        return this.m_presentationCached;
    }

    public void setPresentationCached(boolean presentationCached) {
        this.m_presentationCached = presentationCached;
    }

    public List<GenericPropertyDescription> getProperties() {
        return Collections.unmodifiableList(this.m_properties);
    }

    public GenericPropertyDescription getProperty(String id) {
        return this.m_idToProperty.get(id);
    }

    public void addProperty(GenericPropertyDescription property) {
        String id = property.getId();
        if (!this.m_idToProperty.containsKey(id)) {
            this.m_idToProperty.put(id, property);
            this.m_properties.add(property);
        }
    }

    public List<CreationDescription> getCreations() {
        return List.copyOf(this.m_creations.values());
    }

    public CreationDescription getCreation(String id) {
        return this.m_creations.get(id);
    }

    public void addCreation(CreationDescription creation) {
        this.m_creations.put(creation.getId(), creation);
    }

    public void clearCreations() {
        this.m_creations.clear();
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public boolean hasTrueParameter(String name) {
        String parameter = this.getParameter(name);
        return "true".equals(parameter);
    }

    public List<MorphingTargetDescription> getMorphingTargets() {
        return this.m_morphingTargets;
    }

    public void addMorphingTarget(MorphingTargetDescription morphingTarget) {
        this.m_morphingTargets.add(morphingTarget);
    }

    public void clearMorphingTargets() {
        this.m_morphingTargets.clear();
    }

    public void postProcess() throws Exception {
        Iterator<GenericPropertyDescription> I = this.m_properties.iterator();
        while (I.hasNext()) {
            GenericPropertyDescription property = I.next();
            if (property.getEditor() != null) continue;
            I.remove();
            this.m_idToProperty.remove(property.getId());
        }
        if (this.m_creations.isEmpty()) {
            CreationDescription defaultCreation = new CreationDescription(this, null, null);
            this.addCreation(defaultCreation);
        }
    }

    @Override
    public void visit(XmlObjectInfo object, int state) throws Exception {
        super.visit(object, state);
        for (GenericPropertyDescription property : this.m_idToProperty.values()) {
            property.visit(object, state);
        }
    }
}

