/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.creation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class TagCreationSupport
extends CreationSupport {
    private DocumentElement m_element;
    private String m_tag;

    public TagCreationSupport(DocumentElement element) {
        this.m_element = element;
    }

    public TagCreationSupport(String tag) {
        this.m_tag = tag;
    }

    public String toString() {
        if (this.m_element == null) {
            return this.m_tag;
        }
        return TagCreationSupport.getElementString(this.m_element);
    }

    public static String getElementString(DocumentElement element) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        element.writeShort(printWriter);
        String result = stringWriter.toString();
        result = result.replaceAll("\\s*xmlns:*\\w*=\"[^\"]*\"", "");
        return result;
    }

    @Override
    public DocumentElement getElement() {
        return this.m_element;
    }

    @Override
    public String getTitle() {
        return this.m_element.getTag();
    }

    @Override
    public void delete() throws Exception {
        List<ObjectInfo> children = List.copyOf(this.m_object.getChildren());
        for (ObjectInfo child : children) {
            child.delete();
        }
        DocumentElement elementToRemove = this.getElementToRemove();
        elementToRemove.remove();
        this.m_object.getParent().removeChild((ObjectInfo)this.m_object);
    }

    private DocumentElement getElementToRemove() {
        XmlObjectInfo parent = this.m_object.getParentXML();
        return XmlObjectUtils.getElementInParent(parent, this.m_element);
    }

    @Override
    public void addElement(DocumentElement parent, int index) throws Exception {
        this.m_element = new DocumentElement();
        this.m_element.setTag(this.m_tag);
        parent.addChild(this.m_element, index);
    }
}

