/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.callhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewInput;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewTreeNode;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.ui.PlatformUI;

public class CallHierarchyContentProvider
implements ITreeContentProvider {
    private static final String NO_CALL_HIERARCHY = "No Call Hierarchy for the selected element";
    private static final String FINDING_CALLERS = "Finding callers ...";
    private TreeViewer treeViewer;
    private LanguageServerWrapper languageServerWrapper;
    private List<CallHierarchyViewTreeNode> rootItems;
    private String rootMessage = "Finding callers ...";

    public Object[] getElements(Object inputElement) {
        if (this.rootItems != null) {
            return this.rootItems.toArray();
        }
        return new Object[]{this.rootMessage};
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        Object object = parentElement;
        if (object instanceof CallHierarchyViewTreeNode) {
            void treeNode;
            CallHierarchyViewTreeNode callHierarchyViewTreeNode = (CallHierarchyViewTreeNode)object;
            CallHierarchyViewTreeNode cfr_ignored_0 = (CallHierarchyViewTreeNode)object;
            return this.findCallers((CallHierarchyViewTreeNode)treeNode);
        }
        return new Object[0];
    }

    /*
     * WARNING - void declaration
     */
    public Object getParent(Object element) {
        Object object = element;
        if (object instanceof CallHierarchyViewTreeNode) {
            void treeNode;
            CallHierarchyViewTreeNode callHierarchyViewTreeNode = (CallHierarchyViewTreeNode)object;
            CallHierarchyViewTreeNode cfr_ignored_0 = (CallHierarchyViewTreeNode)object;
            return treeNode.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CallHierarchyViewTreeNode;
    }

    /*
     * WARNING - void declaration
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.treeViewer = (TreeViewer)viewer;
        Object object = newInput;
        if (object instanceof CallHierarchyViewInput) {
            void viewInput;
            CallHierarchyViewInput callHierarchyViewInput = (CallHierarchyViewInput)object;
            CallHierarchyViewInput cfr_ignored_0 = (CallHierarchyViewInput)object;
            this.rootMessage = FINDING_CALLERS;
            this.rootItems = null;
            IDocument document = viewInput.getDocument();
            if (document != null) {
                try {
                    this.initialise(document, viewInput.getOffset());
                }
                catch (BadLocationException e) {
                    this.handleRootError();
                }
            } else {
                this.handleRootError();
            }
        } else {
            this.handleRootError();
        }
    }

    private void initialise(@NonNull IDocument document, int offset) throws BadLocationException {
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getCallHierarchyProvider);
        if (!executor.anyMatching()) {
            this.handleRootError();
            return;
        }
        CallHierarchyPrepareParams prepareParams = LSPEclipseUtils.toCallHierarchyPrepareParams(offset, document);
        ((CompletableFuture)executor.computeFirst((w, ls) -> ls.getTextDocumentService().prepareCallHierarchy(prepareParams).thenApply(result -> new Pair<LanguageServerWrapper, List>((LanguageServerWrapper)w, (List)result))).thenAccept(o -> o.ifPresentOrElse(p -> {
            this.languageServerWrapper = (LanguageServerWrapper)p.getFirst();
            List hierarchyItems = (List)p.getSecond();
            if (!hierarchyItems.isEmpty()) {
                this.rootItems = new ArrayList<CallHierarchyViewTreeNode>(hierarchyItems.size());
                for (CallHierarchyItem item : hierarchyItems) {
                    this.rootItems.add(new CallHierarchyViewTreeNode(item));
                }
            } else {
                this.rootMessage = NO_CALL_HIERARCHY;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (this.treeViewer != null) {
                    this.treeViewer.refresh();
                    this.treeViewer.expandToLevel(2);
                }
            });
        }, this::handleRootError))).handle((result, error) -> {
            if (error != null) {
                this.handleRootError();
            }
            return result;
        });
    }

    private void handleRootError() {
        this.rootItems = Collections.emptyList();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
            }
        });
    }

    private Object[] findCallers(CallHierarchyViewTreeNode callee) {
        if (callee.getChildren() == null) {
            this.treeViewer.getControl().setEnabled(false);
            this.updateCallers(callee);
            return new Object[]{FINDING_CALLERS};
        }
        return callee.getChildren();
    }

    private void updateCallers(CallHierarchyViewTreeNode callee) {
        CallHierarchyIncomingCallsParams incomingCallParams = new CallHierarchyIncomingCallsParams(callee.getCallContainer());
        ((CompletableFuture)this.languageServerWrapper.execute(languageServer -> languageServer.getTextDocumentService().callHierarchyIncomingCalls(incomingCallParams)).thenApply(incomingCalls -> {
            ArrayList<CallHierarchyViewTreeNode> children = new ArrayList<CallHierarchyViewTreeNode>(incomingCalls.size());
            for (CallHierarchyIncomingCall call : incomingCalls) {
                CallHierarchyItem callContainer = call.getFrom();
                List callSites = call.getFromRanges();
                for (Range callSite : callSites) {
                    CallHierarchyViewTreeNode child = new CallHierarchyViewTreeNode(callContainer, callSite);
                    child.setParent(callee);
                    children.add(child);
                }
                if (!callSites.isEmpty()) continue;
                CallHierarchyViewTreeNode child = new CallHierarchyViewTreeNode(callContainer);
                child.setParent(callee);
                children.add(child);
            }
            return children;
        })).handle((result, error) -> this.updateChildrenInView(callee, (List<CallHierarchyViewTreeNode>)result, (Throwable)error));
    }

    private List<CallHierarchyViewTreeNode> updateChildrenInView(CallHierarchyViewTreeNode callee, List<CallHierarchyViewTreeNode> children, Throwable error) {
        if (error != null || children == null) {
            callee.setChildren(Collections.emptyList());
        } else {
            callee.setChildren(children);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
                this.treeViewer.getControl().setEnabled(true);
            }
        });
        return children;
    }

    public void dispose() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().dispose();
            this.treeViewer = null;
        }
    }
}

