/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.spi.edit.remote.review;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;
import org.eclipse.mylyn.reviews.spi.edit.remote.AbstractRemoteEditFactoryProvider;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public abstract class ReviewsRemoteEditFactoryProvider
extends AbstractRemoteEditFactoryProvider<IRepository, IReview>
implements IReviewRemoteFactoryProvider {
    private final TaskRepository taskRepository;

    public ReviewsRemoteEditFactoryProvider(TaskRepository repository) {
        super((EFactory)IReviewsFactory.INSTANCE, ReviewsPackage.Literals.REPOSITORY__REVIEWS, ReviewsPackage.Literals.CHANGE__ID, ReviewsPackage.Literals.REVIEW);
        this.taskRepository = repository;
    }

    @Override
    public IRepository open() {
        IRepository modelRepository = (IRepository)super.open();
        modelRepository.setTaskRepository(this.taskRepository);
        modelRepository.setTaskRepositoryUrl(this.taskRepository.getUrl());
        modelRepository.setTaskConnectorKind(this.taskRepository.getConnectorKind());
        return modelRepository;
    }

    @Override
    public String getContainerSegment() {
        try {
            return String.valueOf(this.taskRepository.getConnectorKind()) + "-" + ReviewsRemoteEditFactoryProvider.asFileName(this.taskRepository.getUrl());
        }
        catch (MalformedURLException e) {
            RepositoryStatus.createStatus((TaskRepository)this.taskRepository, (int)4, (String)"org.eclipse.mylyn.reviews.edit", (String)("Bad repository url: " + this.taskRepository.getUrl()));
            return "BadRepository";
        }
    }

    public static String asFileName(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return String.valueOf(url.getProtocol()) + "-" + url.getHost() + "-" + url.getPath().replace('/', '-');
    }

    @Override
    public String getFileExtension(EClass eClass) {
        return "reviews";
    }
}

