/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.equinox.internal.region.BundleIdBasedRegion;
import org.eclipse.equinox.internal.region.BundleIdToRegionMapping;
import org.eclipse.equinox.internal.region.RegionLifecycleListener;
import org.eclipse.equinox.internal.region.StandardBundleIdToRegionMapping;
import org.eclipse.equinox.internal.region.StandardRegionDigraphPersistence;
import org.eclipse.equinox.internal.region.StandardRegionFilterBuilder;
import org.eclipse.equinox.internal.region.SubgraphTraverser;
import org.eclipse.equinox.internal.region.hook.RegionBundleCollisionHook;
import org.eclipse.equinox.internal.region.hook.RegionBundleEventHook;
import org.eclipse.equinox.internal.region.hook.RegionBundleFindHook;
import org.eclipse.equinox.internal.region.hook.RegionResolverHookFactory;
import org.eclipse.equinox.internal.region.hook.RegionServiceEventHook;
import org.eclipse.equinox.internal.region.hook.RegionServiceFindHook;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphPersistence;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;

public final class StandardRegionDigraph
implements BundleIdToRegionMapping,
RegionDigraph {
    private static final Set<RegionDigraph.FilteredRegion> EMPTY_EDGE_SET = Collections.unmodifiableSet(new HashSet());
    private final Object monitor = new Object();
    private final Map<String, Region> regions = new HashMap<String, Region>();
    private final BundleIdToRegionMapping bundleIdToRegionMapping;
    private final Map<Region, Set<RegionDigraph.FilteredRegion>> edges = new HashMap<Region, Set<RegionDigraph.FilteredRegion>>();
    private final BundleContext bundleContext;
    private final ThreadLocal<Region> threadLocal;
    private final SubgraphTraverser subgraphTraverser;
    private final CollisionHook bundleCollisionHook;
    private final EventHook bundleEventHook;
    private final FindHook bundleFindHook;
    private final org.osgi.framework.hooks.service.EventHook serviceEventHook;
    private final org.osgi.framework.hooks.service.FindHook serviceFindHook;
    private final ResolverHookFactory resolverHookFactory;
    private final StandardRegionDigraph origin;
    private long originUpdateCount;
    private final AtomicLong updateCount = new AtomicLong();
    private volatile Region defaultRegion;

    public StandardRegionDigraph(StandardRegionDigraph origin) throws BundleException {
        this(null, null, origin);
    }

    public StandardRegionDigraph(BundleContext bundleContext, ThreadLocal<Region> threadLocal) throws BundleException {
        this(bundleContext, threadLocal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardRegionDigraph(BundleContext bundleContext, ThreadLocal<Region> threadLocal, StandardRegionDigraph origin) throws BundleException {
        this.subgraphTraverser = new SubgraphTraverser();
        this.bundleIdToRegionMapping = new StandardBundleIdToRegionMapping();
        this.bundleContext = bundleContext;
        this.threadLocal = threadLocal;
        this.resolverHookFactory = new RegionResolverHookFactory(this);
        this.bundleFindHook = new RegionBundleFindHook(this, bundleContext == null ? 0L : bundleContext.getBundle().getBundleId());
        this.bundleEventHook = new RegionBundleEventHook(this, this.threadLocal, bundleContext == null ? 0L : bundleContext.getBundle().getBundleId());
        this.bundleCollisionHook = new RegionBundleCollisionHook(this, this.threadLocal);
        this.serviceFindHook = new RegionServiceFindHook(this);
        this.serviceEventHook = new RegionServiceEventHook(this);
        this.origin = origin;
        if (origin != null) {
            Object object = origin.monitor;
            synchronized (object) {
                this.originUpdateCount = origin.updateCount.get();
                this.replace(origin, false);
            }
        } else {
            this.originUpdateCount = -1L;
        }
        this.defaultRegion = null;
    }

    @Override
    public Region createRegion(String regionName) throws BundleException {
        return this.createRegion(regionName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region createRegion(String regionName, boolean notify) throws BundleException {
        BundleIdBasedRegion region = new BundleIdBasedRegion(regionName, this, this, this.bundleContext, this.threadLocal);
        Object object = this.monitor;
        synchronized (object) {
            if (this.getRegion(regionName) != null) {
                throw new BundleException("Region '" + regionName + "' already exists", 1);
            }
            this.regions.put(region.getName(), region);
            this.edges.put(region, EMPTY_EDGE_SET);
            this.incrementUpdateCount();
        }
        if (notify) {
            this.notifyAdded(region);
        }
        return region;
    }

    @Override
    public void connect(Region tailRegion, RegionFilter filter, Region headRegion) throws BundleException {
        this.createConnection(tailRegion, filter, headRegion, false);
    }

    @Override
    public RegionFilter replaceConnection(Region tailRegion, RegionFilter filter, Region headRegion) throws BundleException {
        return this.createConnection(tailRegion, filter, headRegion, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionFilter createConnection(Region tailRegion, RegionFilter filter, Region headRegion, boolean replace) throws BundleException {
        if (tailRegion == null) {
            throw new IllegalArgumentException("The tailRegion must not be null.");
        }
        if (!replace && filter == null) {
            throw new IllegalArgumentException("The filter must not be null.");
        }
        if (headRegion == null) {
            throw new IllegalArgumentException("The headRegion must not be null.");
        }
        if (headRegion.equals(tailRegion)) {
            throw new BundleException("Cannot connect region '" + headRegion + "' to itself", 1);
        }
        if (tailRegion.getRegionDigraph() != this) {
            throw new IllegalArgumentException("The tailRegion does not belong to this digraph.");
        }
        if (headRegion.getRegionDigraph() != this) {
            throw new IllegalArgumentException("The headRegion does not belong to this digraph.");
        }
        RegionDigraph.FilteredRegion existing = null;
        boolean tailAdded = false;
        boolean headAdded = false;
        Object object = this.monitor;
        synchronized (object) {
            Set<RegionDigraph.FilteredRegion> connections = this.edges.get(tailRegion);
            if (connections == null) {
                connections = new HashSet<RegionDigraph.FilteredRegion>();
            } else {
                connections = new HashSet<RegionDigraph.FilteredRegion>(connections);
                for (RegionDigraph.FilteredRegion edge : connections) {
                    if (!headRegion.equals(edge.getRegion())) continue;
                    if (replace) {
                        existing = edge;
                        continue;
                    }
                    throw new BundleException("Region '" + tailRegion + "' is already connected to region '" + headRegion, 1);
                }
            }
            this.checkFilterDoesNotAllowExistingBundle(tailRegion, filter);
            tailAdded = this.regions.put(tailRegion.getName(), tailRegion) == null;
            boolean bl = headAdded = this.regions.put(headRegion.getName(), headRegion) == null;
            if (existing != null) {
                connections.remove(existing);
            }
            if (filter != null) {
                connections.add(new StandardFilteredRegion(headRegion, filter));
            }
            this.edges.put(tailRegion, Collections.unmodifiableSet(connections));
            this.incrementUpdateCount();
        }
        if (tailAdded) {
            this.notifyAdded(tailRegion);
        }
        if (headAdded) {
            this.notifyAdded(headRegion);
        }
        return existing == null ? null : existing.getFilter();
    }

    private void checkFilterDoesNotAllowExistingBundle(Region tailRegion, RegionFilter filter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Region> iterator() {
        Object object = this.monitor;
        synchronized (object) {
            HashSet<Region> snapshot = new HashSet<Region>(this.regions.size());
            snapshot.addAll(this.regions.values());
            return snapshot.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RegionDigraph.FilteredRegion> getEdges(Region tailRegion) {
        Object object = this.monitor;
        synchronized (object) {
            Set<RegionDigraph.FilteredRegion> edgeSet = this.edges.get(tailRegion);
            return edgeSet == null ? EMPTY_EDGE_SET : edgeSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(String regionName) {
        Object object = this.monitor;
        synchronized (object) {
            return this.regions.get(regionName);
        }
    }

    @Override
    public Region getRegion(Bundle bundle) {
        return this.getRegion(bundle.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(long bundleId) {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundleIdToRegionMapping.getRegion(bundleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("The region cannot be null.");
        }
        this.notifyRemoving(region);
        Object object = this.monitor;
        synchronized (object) {
            if (this.defaultRegion != null && this.defaultRegion.equals(region)) {
                this.defaultRegion = null;
            }
            this.regions.remove(region.getName());
            this.edges.remove(region);
            block3: for (Map.Entry<Region, Set<RegionDigraph.FilteredRegion>> entry : this.edges.entrySet()) {
                Region r = entry.getKey();
                Set<RegionDigraph.FilteredRegion> edgeSet = entry.getValue();
                for (RegionDigraph.FilteredRegion edge : edgeSet) {
                    if (!region.equals(edge.getRegion())) continue;
                    HashSet<RegionDigraph.FilteredRegion> mutableEdgeSet = new HashSet<RegionDigraph.FilteredRegion>(edgeSet);
                    mutableEdgeSet.remove(edge);
                    this.edges.put(r, Collections.unmodifiableSet(mutableEdgeSet));
                    continue block3;
                }
            }
            this.bundleIdToRegionMapping.dissociateRegion(region);
            this.incrementUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.monitor;
        synchronized (object) {
            StringBuffer s = new StringBuffer();
            boolean first = true;
            s.append("RegionDigraph{");
            for (Region r : this) {
                if (!first) {
                    s.append(", ");
                }
                s.append(r);
                first = false;
            }
            s.append("}");
            s.append("[");
            first = true;
            for (Region r : this) {
                Set<RegionDigraph.FilteredRegion> edgeSet = this.edges.get(r);
                if (edgeSet == null) continue;
                for (RegionDigraph.FilteredRegion filteredRegion : edgeSet) {
                    if (!first) {
                        s.append(", ");
                    }
                    s.append(r + "->" + filteredRegion.getRegion());
                    first = false;
                }
            }
            s.append("]");
            return s.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Region> getRegions() {
        HashSet<Region> result = new HashSet<Region>();
        Object object = this.monitor;
        synchronized (object) {
            result.addAll(this.regions.values());
        }
        return result;
    }

    @Override
    public RegionFilterBuilder createRegionFilterBuilder() {
        return new StandardRegionFilterBuilder();
    }

    private void notifyAdded(Region region) {
        Set<RegionLifecycleListener> listeners = this.getListeners();
        for (RegionLifecycleListener listener : listeners) {
            listener.regionAdded(region);
        }
    }

    private void notifyRemoving(Region region) {
        Set<RegionLifecycleListener> listeners = this.getListeners();
        for (RegionLifecycleListener listener : listeners) {
            listener.regionRemoving(region);
        }
    }

    private Set<RegionLifecycleListener> getListeners() {
        if (this.bundleContext == null) {
            return Collections.emptySet();
        }
        HashSet<RegionLifecycleListener> listeners = new HashSet<RegionLifecycleListener>();
        try {
            Collection listenerServiceReferences = this.bundleContext.getServiceReferences(RegionLifecycleListener.class, null);
            for (ServiceReference listenerServiceReference : listenerServiceReferences) {
                RegionLifecycleListener regionLifecycleListener = (RegionLifecycleListener)this.bundleContext.getService(listenerServiceReference);
                if (regionLifecycleListener == null) continue;
                listeners.add(regionLifecycleListener);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return listeners;
    }

    @Override
    public void visitSubgraph(Region startingRegion, RegionDigraphVisitor visitor) {
        this.subgraphTraverser.visitSubgraph(startingRegion, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Region, Set<RegionDigraph.FilteredRegion>> getFilteredRegions() {
        Object object = this.monitor;
        synchronized (object) {
            return new HashMap<Region, Set<RegionDigraph.FilteredRegion>>(this.edges);
        }
    }

    @Override
    public RegionDigraphPersistence getRegionDigraphPersistence() {
        return new StandardRegionDigraphPersistence();
    }

    @Override
    public RegionDigraph copy() throws BundleException {
        return new StandardRegionDigraph(this);
    }

    @Override
    public void replace(RegionDigraph digraph) throws BundleException {
        this.replace(digraph, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(RegionDigraph digraph, boolean check) throws BundleException {
        if (!(digraph instanceof StandardRegionDigraph)) {
            throw new IllegalArgumentException("Only digraphs of type '" + StandardRegionDigraph.class.getName() + "' are allowed: " + digraph.getClass().getName());
        }
        StandardRegionDigraph replacement = (StandardRegionDigraph)digraph;
        if (check && replacement.origin != this) {
            throw new IllegalArgumentException("The replacement digraph is not a copy of this digraph.");
        }
        Set<Region> removed = this.getRegions();
        removed.removeAll(replacement.getRegions());
        for (Region region : removed) {
            this.notifyRemoving(region);
        }
        Map<Region, Set<RegionDigraph.FilteredRegion>> filteredRegions = replacement.getFilteredRegions();
        HashSet<Region> added = new HashSet<Region>();
        Object object = this.monitor;
        synchronized (object) {
            if (check && this.updateCount.get() != replacement.originUpdateCount) {
                throw new BundleException("The origin update count has changed since the replacement copy was created.", 2);
            }
            HashMap<String, Region> nameToRegion = new HashMap<String, Region>(this.regions);
            this.regions.clear();
            this.edges.clear();
            this.bundleIdToRegionMapping.clear();
            for (Region region : filteredRegions.keySet()) {
                Region copy = (Region)nameToRegion.get(region.getName());
                if (copy != null) {
                    this.regions.put(copy.getName(), copy);
                    this.edges.put(copy, EMPTY_EDGE_SET);
                } else {
                    copy = this.createRegion(region.getName(), false);
                    added.add(copy);
                }
                for (Long id : region.getBundleIds()) {
                    copy.addBundle(id);
                }
            }
            for (Map.Entry entry : filteredRegions.entrySet()) {
                Region tailRegion = this.getRegion(((Region)entry.getKey()).getName());
                for (RegionDigraph.FilteredRegion headFilter : (Set)entry.getValue()) {
                    Region headRegion = this.getRegion(headFilter.getRegion().getName());
                    this.connect(tailRegion, headFilter.getFilter(), headRegion);
                }
            }
            this.incrementUpdateCount();
            if (check) {
                replacement.originUpdateCount = this.updateCount.get();
            }
        }
        for (Region region : added) {
            this.notifyAdded(region);
        }
    }

    @Override
    public ResolverHookFactory getResolverHookFactory() {
        return this.resolverHookFactory;
    }

    CollisionHook getBundleCollisionHook() {
        return this.bundleCollisionHook;
    }

    @Override
    public EventHook getBundleEventHook() {
        return this.bundleEventHook;
    }

    @Override
    public FindHook getBundleFindHook() {
        return this.bundleFindHook;
    }

    @Override
    public org.osgi.framework.hooks.service.EventHook getServiceEventHook() {
        return this.serviceEventHook;
    }

    @Override
    public org.osgi.framework.hooks.service.FindHook getServiceFindHook() {
        return this.serviceFindHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultRegion(Region defaultRegion) {
        Object object = this.monitor;
        synchronized (object) {
            if (defaultRegion != null) {
                this.checkRegionExists(defaultRegion);
            }
            this.defaultRegion = defaultRegion;
        }
    }

    @Override
    public Region getDefaultRegion() {
        return this.defaultRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateBundleWithRegion(long bundleId, Region region) throws BundleException {
        Object object = this.monitor;
        synchronized (object) {
            this.checkRegionExists(region);
            this.bundleIdToRegionMapping.associateBundleWithRegion(bundleId, region);
            this.incrementUpdateCount();
        }
    }

    private void checkRegionExists(Region region) {
        if (this.regions.get(region.getName()) == null) {
            throw new IllegalStateException("Operation not allowed on region " + region.getName() + " which is not part of a digraph");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementUpdateCount() {
        Object object = this.monitor;
        synchronized (object) {
            this.updateCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociateBundleFromRegion(long bundleId, Region region) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkRegionExists(region);
            this.bundleIdToRegionMapping.dissociateBundleFromRegion(bundleId, region);
            this.incrementUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBundleAssociatedWithRegion(long bundleId, Region region) {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundleIdToRegionMapping.isBundleAssociatedWithRegion(bundleId, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getBundleIds(Region region) {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundleIdToRegionMapping.getBundleIds(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleIdToRegionMapping.clear();
            this.incrementUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociateRegion(Region region) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleIdToRegionMapping.dissociateRegion(region);
            this.incrementUpdateCount();
        }
    }

    static class StandardFilteredRegion
    implements RegionDigraph.FilteredRegion {
        private Region region;
        private RegionFilter regionFilter;

        StandardFilteredRegion(Region region, RegionFilter regionFilter) {
            this.region = region;
            this.regionFilter = regionFilter;
        }

        @Override
        public Region getRegion() {
            return this.region;
        }

        @Override
        public RegionFilter getFilter() {
            return this.regionFilter;
        }
    }
}

