/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutRepositoryPage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizard;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.widgets.ComposeBranchPointComposite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CheckoutBranchPointPage
extends CheckoutWizardPage {
    private static final IContainer<Object> CONNECTING_INPUT = ContainerItemProvider.createSlowInput((String)"Connecting...");
    private int branchID = 0;
    private long timeStamp = 0L;
    private ComposeBranchPointComposite branchPointComposite;
    private String timeStampError;

    public CheckoutBranchPointPage() {
        super("Branch Point", "Select the branch point of the new checkout.");
    }

    public final int getBranchID() {
        return this.branchID;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public final CDOBranchPoint getBranchPoint() {
        CheckoutRepositoryPage repositoryPage = this.getWizard().getRepositoryPage();
        CDOSession session = repositoryPage.getSession();
        CDOBranchManager branchManager = session.getBranchManager();
        CDOBranch branch = branchManager.getBranch(this.branchID);
        return branch.getPoint(this.timeStamp);
    }

    public void setBranchPoint(int branchID, long timeStamp) {
        if (this.branchID != branchID || this.timeStamp != timeStamp) {
            CheckoutBranchPointPage.log("Setting branch point to " + branchID + "/" + CDOCommonUtil.formatTimeStamp((long)timeStamp));
            this.branchID = branchID;
            this.timeStamp = timeStamp;
            if (this.branchPointComposite != null) {
                CDOBranchPoint branchPoint = this.getBranchPoint();
                CDOBranch branch = branchPoint.getBranch();
                TreeViewer branchViewer = this.branchPointComposite.getBranchViewer();
                branchViewer.setSelection((ISelection)new StructuredSelection((Object)branch));
                branchViewer.setExpandedState((Object)branch, true);
            }
            this.branchPointChanged(branchID, timeStamp);
        }
    }

    protected void createUI(Composite parent) {
        CDOBranchPoint branchPoint = this.getBranchPoint();
        this.branchPointComposite = new ComposeBranchPointComposite(parent, true, branchPoint){

            protected void timeStampError(String message) {
                CheckoutBranchPointPage.this.timeStampError = message;
                CheckoutBranchPointPage.this.validate();
            }

            protected void branchPointChanged(CDOBranchPoint branchPoint) {
                int id = branchPoint.getBranch().getID();
                long timeStamp = branchPoint.getTimeStamp();
                CheckoutBranchPointPage.this.setBranchPoint(id, timeStamp);
                CheckoutBranchPointPage.this.validate();
            }

            protected void doubleClicked() {
                CheckoutBranchPointPage.this.showNextPage();
            }
        };
        this.branchPointComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.branchPointComposite.getBranchViewer().setInput(CONNECTING_INPUT);
    }

    protected void repositoryChanged(CDORepository repository) {
        if (this.branchPointComposite != null) {
            TreeViewer branchViewer = this.branchPointComposite.getBranchViewer();
            branchViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            branchViewer.setInput(CONNECTING_INPUT);
        }
        super.repositoryChanged(repository);
    }

    protected void pageActivated() {
        final CheckoutWizard wizard = this.getWizard();
        String type = wizard.getTypePage().getType();
        if ("online-transactional".equals(type)) {
            this.branchPointComposite.setAllowTimeStamp(false);
        } else {
            this.branchPointComposite.setAllowTimeStamp(true);
            this.branchPointComposite.getSelectTimeComposite().setTimeStamp(this.timeStamp);
        }
        final Display display = this.branchPointComposite.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                CDOSession session = wizard.getRepositoryPage().getSession();
                final CDOBranchPoint branchPoint = wizard.getBranchPointPage().getBranchPoint();
                final TreeViewer branchViewer = CheckoutBranchPointPage.this.branchPointComposite.getBranchViewer();
                branchViewer.setInput((Object)session.getBranchManager());
                display.asyncExec(new Runnable(){

                    public void run() {
                        CDOBranch branch = branchPoint.getBranch();
                        branchViewer.setSelection((ISelection)new StructuredSelection((Object)branch));
                        branchViewer.expandToLevel((Object)branch, 1);
                        CheckoutBranchPointPage.this.validate();
                    }
                });
            }
        });
    }

    protected boolean doValidate() throws CheckoutWizardPage.ValidationProblem {
        TreeViewer branchViewer = this.branchPointComposite.getBranchViewer();
        if (branchViewer.getInput() == null) {
            return false;
        }
        ISelection selection = branchViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (this.timeStampError != null) {
            throw new CheckoutWizardPage.ValidationProblem(this.timeStampError);
        }
        return true;
    }

    protected void fillProperties(Properties properties) {
        properties.setProperty("branchID", Integer.toString(this.branchID));
        properties.setProperty("timeStamp", Long.toString(this.timeStamp));
    }
}

