/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.network.server;

import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.rcptt.tesla.core.protocol.TeslaStream;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.network.DataSerializer;

public class NetworkTeslaClient
extends AbstractTeslaClient {
    private DataOutputStream dataOutput;
    private LocalEmptyStream stream;

    public NetworkTeslaClient(DataOutputStream dout, String id) {
        super(id);
        this.dataOutput = dout;
    }

    @Override
    public boolean hasCommand() {
        return this.localQueue.isEmpty();
    }

    @Override
    protected TeslaStream stream() {
        if (this.stream == null) {
            this.stream = new LocalEmptyStream();
        }
        return this.stream;
    }

    public void waitForExecution(Command cmd) {
    }

    @Override
    public void logException(Throwable t) {
        TeslaCore.log(t);
    }

    private final class LocalEmptyStream
    extends TeslaStream {
        private LocalEmptyStream() {
        }

        @Override
        public void terminate() {
        }

        @Override
        public Response readResponse() {
            return null;
        }

        @Override
        public Command readCommand() {
            return null;
        }

        @Override
        public void writeResponse(Response command) {
            try {
                DataSerializer.writeEObject(NetworkTeslaClient.this.dataOutput, command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void writeCommand(Command command) {
        }
    }
}

