/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ui.refactoring.rename.RenameNamedElementChange;
import org.eclipse.rcptt.util.FileUtil;

public class FilenameUpdater {
    private String originalName;

    public FilenameUpdater(IQ7NamedElement element) throws ModelException {
        this.originalName = element.getElementName();
    }

    public void update(IQ7NamedElement element) throws ModelException {
        if (element.getElementName().equals(this.originalName)) {
            return;
        }
        IResource resource = element.getResource();
        this.originalName = element.getElementName();
        String newName = FilenameUpdater.selectNewName(resource, element.getElementName());
        if (newName == null) {
            return;
        }
        try {
            RenameNamedElementChange change = new RenameNamedElementChange(resource.getFullPath(), newName, element.getElementName());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    private static String selectNewName(IResource resource, String elementName) {
        String newName = FileUtil.escapeFileName((String)elementName, null);
        IContainer container = resource.getParent();
        int counter = 0;
        String possibleName;
        IResource existingResource;
        while ((existingResource = container.findMember(possibleName = (String)(counter == 0 ? newName : newName + " (" + counter + ")") + "." + resource.getFileExtension())) != null) {
            if (existingResource.equals((Object)resource)) {
                return null;
            }
            ++counter;
        }
        return possibleName;
    }
}

