/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.ecl.debug.runtime.IEclDebugExtension;
import org.eclipse.rcptt.ecl.internal.debug.runtime.EclDebugRuntimePlugin;

public class DebugExtensionManager {
    private static DebugExtensionManager instance;
    private List<Entry> providers = null;

    public static synchronized DebugExtensionManager getInstance() {
        if (instance == null) {
            instance = new DebugExtensionManager();
        }
        return instance;
    }

    public List<IEclDebugExtension> getExtensions() {
        this.initialize();
        ArrayList<IEclDebugExtension> result = new ArrayList<IEclDebugExtension>();
        for (Entry e : this.providers) {
            result.add(e.provider);
        }
        return result;
    }

    private synchronized void initialize() {
        if (this.providers == null) {
            IConfigurationElement[] elements;
            this.providers = new ArrayList<Entry>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.ecl.debug.runtime", "eclDebugExtension");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Entry ee = new Entry();
                    ee.id = e.getAttribute("id");
                    ee.priority = Integer.parseInt(e.getAttribute("priority"));
                    ee.provider = (IEclDebugExtension)e.createExecutableExtension("class");
                    this.providers.add(ee);
                }
                catch (Exception eee) {
                    EclDebugRuntimePlugin.log(eee.getMessage(), eee);
                }
                ++n2;
            }
            Collections.sort(this.providers, new Comparator<Entry>(){

                @Override
                public int compare(Entry arg0, Entry arg1) {
                    return Integer.valueOf(arg0.priority).compareTo(arg1.priority);
                }
            });
        }
    }

    private class Entry {
        String id;
        int priority;
        IEclDebugExtension provider;

        private Entry() {
        }
    }
}

