/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class LastSaveReferenceProvider
implements IQuickDiffReferenceProvider,
IElementStateListener {
    private boolean fDocumentRead = false;
    private IDocument fReference = null;
    private String fId;
    private IDocumentProvider fDocumentProvider;
    private IEditorInput fEditorInput;
    private final Object fLock = new Object();
    private final Object fDocumentAccessorLock = new Object();
    private boolean fDocumentLocked;
    private IProgressMonitor fProgressMonitor;
    private ITextEditor fEditor;

    public IDocument getReference(IProgressMonitor monitor) {
        if (!this.fDocumentRead) {
            this.readDocument(monitor, true);
        }
        return this.fReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IProgressMonitor monitor = this.fProgressMonitor;
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        IDocumentProvider provider = this.fDocumentProvider;
        Object object = this.fLock;
        synchronized (object) {
            if (provider != null) {
                provider.removeElementStateListener((IElementStateListener)this);
            }
            this.fEditorInput = null;
            this.fDocumentProvider = null;
            this.fReference = null;
            this.fDocumentRead = false;
            this.fProgressMonitor = null;
            this.fEditor = null;
        }
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveEditor(ITextEditor targetEditor) {
        IDocumentProvider provider = null;
        IEditorInput input = null;
        if (targetEditor != null) {
            provider = targetEditor.getDocumentProvider();
            input = targetEditor.getEditorInput();
        }
        if (provider != this.fDocumentProvider || input != this.fEditorInput) {
            this.dispose();
            Object object = this.fLock;
            synchronized (object) {
                this.fEditor = targetEditor;
                this.fDocumentProvider = provider;
                this.fEditorInput = input;
            }
        }
    }

    public boolean isEnabled() {
        return this.fEditorInput != null && this.fDocumentProvider != null;
    }

    public void setId(String id) {
        this.fId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDocument(IProgressMonitor monitor, boolean force) {
        IDocumentProvider prov = this.fDocumentProvider;
        IEditorInput inp = this.fEditorInput;
        IDocument doc = this.fReference;
        ITextEditor editor = this.fEditor;
        if (prov instanceof IStorageDocumentProvider && inp instanceof IStorageEditorInput) {
            IStorageEditorInput input = (IStorageEditorInput)inp;
            IStorageDocumentProvider provider = (IStorageDocumentProvider)prov;
            if (doc == null) {
                if (force || this.fDocumentRead) {
                    doc = new Document();
                } else {
                    return;
                }
            }
            IJobManager jobMgr = Job.getJobManager();
            try {
                IStorage storage = input.getStorage();
                if (storage == null) {
                    return;
                }
                this.fProgressMonitor = monitor;
                ISchedulingRule rule = this.getSchedulingRule(storage);
                try {
                    this.lockDocument(monitor, jobMgr, rule);
                    String encoding = storage instanceof IEncodedStorage ? ((IEncodedStorage)storage).getCharset() : null;
                    boolean skipUTF8BOM = LastSaveReferenceProvider.isUTF8BOM(encoding, storage);
                    LastSaveReferenceProvider.setDocumentContent(doc, storage, encoding, monitor, skipUTF8BOM);
                }
                finally {
                    this.unlockDocument(jobMgr, rule);
                    this.fProgressMonitor = null;
                }
            }
            catch (CoreException e) {
                return;
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            Object object = this.fLock;
            synchronized (object) {
                if (this.fDocumentProvider == provider && this.fEditorInput == input) {
                    this.fReference = doc;
                    this.fDocumentRead = true;
                    this.addElementStateListener(editor, prov);
                }
            }
        }
    }

    private ISchedulingRule getSchedulingRule(IStorage storage) {
        if (storage instanceof ISchedulingRule) {
            return (ISchedulingRule)storage;
        }
        if (storage != null) {
            return (ISchedulingRule)storage.getAdapter(ISchedulingRule.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDocument(IProgressMonitor monitor, IJobManager jobMgr, ISchedulingRule rule) {
        if (rule != null) {
            jobMgr.beginRule(rule, monitor);
        } else {
            Object object = this.fDocumentAccessorLock;
            synchronized (object) {
                while (this.fDocumentLocked) {
                    try {
                        this.fDocumentAccessorLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new OperationCanceledException();
                    }
                }
                this.fDocumentLocked = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockDocument(IJobManager jobMgr, ISchedulingRule rule) {
        if (rule != null) {
            jobMgr.endRule(rule);
        } else {
            Object object = this.fDocumentAccessorLock;
            synchronized (object) {
                this.fDocumentLocked = false;
                this.fDocumentAccessorLock.notifyAll();
            }
        }
    }

    private void addElementStateListener(ITextEditor editor, IDocumentProvider provider) {
        Shell shell;
        IWorkbenchWindow window;
        IWorkbenchPartSite site;
        Runnable runnable = () -> {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fDocumentProvider == provider) {
                    provider.addElementStateListener((IElementStateListener)this);
                }
            }
        };
        Display display = null;
        if (editor != null && (site = editor.getSite()) != null && (window = site.getWorkbenchWindow()) != null && (shell = window.getShell()) != null) {
            display = shell.getDisplay();
        }
        if (display != null && !display.isDisposed()) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private static void setDocumentContent(IDocument document, IStorage storage, String encoding, IProgressMonitor monitor, boolean skipUTF8BOM) throws CoreException {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream contentStream = storage.getContents();){
                byte[] bom;
                if (skipUTF8BOM && (bom = contentStream.readNBytes(IContentDescription.BOM_UTF_8.length)).length != IContentDescription.BOM_UTF_8.length) {
                    throw new IOException(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.notEnoughBytesForBOM"));
                }
                try {
                    String content = new String(contentStream.readAllBytes(), encoding);
                    document.set(content);
                }
                catch (OutOfMemoryError e) {
                    throw new IOException("OutOfMemoryError occurred while reading " + String.valueOf(storage.getFullPath()), e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException x) {
            throw new CoreException(Status.error((String)("Failed to access or read " + String.valueOf(storage.getFullPath())), (Throwable)x));
        }
    }

    private static boolean isUTF8BOM(String encoding, IStorage storage) throws CoreException {
        byte[] bom;
        IFile file;
        IContentDescription description;
        if (storage instanceof IFile && StandardCharsets.UTF_8.name().equals(encoding) && (description = (file = (IFile)storage).getContentDescription()) != null && (bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
            if (bom != IContentDescription.BOM_UTF_8) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.wrongByteOrderMark"), null));
            }
            return true;
        }
        return false;
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
        if (!isDirty && element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        if (element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementDeleted(Object element) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    private final class ReadJob
    extends Job {
        public ReadJob() {
            super(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.readJob.label"));
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LastSaveReferenceProvider.this.readDocument(monitor, false);
            return Status.OK_STATUS;
        }
    }
}

