/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.spy.sections;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.spy.SpyFormToolkit;
import org.eclipse.pde.internal.runtime.spy.sections.ISpySection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ActivePartSection
implements ISpySection {
    @Override
    public void build(ScrolledForm form, SpyFormToolkit toolkit, ExecutionEvent event) {
        PageBookView outline;
        IPage currentPage;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            return;
        }
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return;
        }
        String partType = part instanceof IEditorPart ? "editor" : "view";
        Section section = toolkit.createSection(form.getBody(), 256);
        section.setText(NLS.bind((String)PDERuntimeMessages.SpyDialog_activePart_title, (Object)part.getSite().getRegisteredName()));
        FormText text = toolkit.createFormText((Composite)section, true);
        section.setClient((Control)text);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        MPart mPart = null;
        if (part instanceof E4PartWrapper) {
            EPartService service = (EPartService)part.getSite().getService(EPartService.class);
            mPart = service.findPart(part.getSite().getId());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form>");
        if (mPart == null || mPart.getObject() == null) {
            buffer.append(toolkit.createClassSection(text, NLS.bind((String)PDERuntimeMessages.SpyDialog_activePart_desc, (Object)partType), part.getClass()));
        } else {
            buffer.append(toolkit.createClassSection(text, NLS.bind((String)PDERuntimeMessages.SpyDialog_activePart_desc, (Object)partType), part.getClass(), mPart.getObject().getClass()));
        }
        if (part instanceof PageBookView && (currentPage = (outline = (PageBookView)part).getCurrentPage()) != null) {
            buffer.append(toolkit.createClassSection(text, PDERuntimeMessages.SpyDialog_activePageBook_title, currentPage.getClass()));
        }
        Bundle bundle = null;
        if (mPart == null) {
            bundle = FrameworkUtil.getBundle(part.getClass());
        } else if (mPart.getObject() != null) {
            bundle = FrameworkUtil.getBundle(mPart.getObject().getClass());
        }
        toolkit.generatePluginDetailsText(bundle, part.getSite().getId(), partType, buffer, text);
        try {
            PartSite site = (PartSite)part.getSite();
            Class<?> clazz = site.getClass().getSuperclass();
            Field field = clazz.getDeclaredField("menuExtenders");
            field.setAccessible(true);
            List list = (List)field.get(site);
            if (list != null && !list.isEmpty()) {
                LinkedHashSet menuIds = new LinkedHashSet();
                int i = 0;
                while (i < list.size()) {
                    PopupMenuExtender extender = (PopupMenuExtender)list.get(i);
                    menuIds.addAll(extender.getMenuIds());
                    ++i;
                }
                buffer.append("<p>");
                buffer.append(PDERuntimeMessages.SpyDialog_activeMenuIds);
                buffer.append("</p>");
                Iterator it = menuIds.iterator();
                while (it.hasNext()) {
                    buffer.append("<li bindent=\"20\" style=\"image\" value=\"menu\">");
                    buffer.append(((String)it.next()).toString());
                    buffer.append("</li>");
                }
                Image menuImage = PDERuntimePluginImages.get("menu_obj.svg");
                text.setImage("menu", menuImage);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            PDERuntimePlugin.log(e);
        }
        buffer.append("</form>");
        Image idImage = PDERuntimePluginImages.get("generic_xml_obj.svg");
        text.setImage("id", idImage);
        text.setText(buffer.toString(), true, false);
        text.requestLayout();
    }
}

