/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.Set;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.StackFrameCategorizer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class StackFramePresentationProvider
implements IPropertyChangeListener {
    private static final Set<String> JAR_ICON = Set.of(StackFrameCategorizer.CATEGORY_LIBRARY.name(), StackFrameCategorizer.CATEGORY_SYNTHETIC.name(), StackFrameCategorizer.CATEGORY_PLATFORM.name());
    private final IPreferenceStore store;
    private boolean collapseStackFrames;

    public StackFramePresentationProvider(IPreferenceStore store) {
        this.store = store;
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.collapseStackFrames = store.getBoolean(IJDIPreferencesConstants.PREF_COLLAPSE_STACK_FRAMES);
    }

    public StackFramePresentationProvider() {
        this(JDIDebugUIPlugin.getDefault().getPreferenceStore());
    }

    public ImageDescriptor getStackFrameImage(IJavaStackFrame frame) {
        IJavaStackFrame.Category category;
        if (this.collapseStackFrames && (category = frame.getCategory()) != null && JAR_ICON.contains(category.name())) {
            return JavaPluginImages.DESC_OBJS_JAR;
        }
        return null;
    }

    public void close() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (IJDIPreferencesConstants.PREF_COLLAPSE_STACK_FRAMES.equals(prop)) {
            this.collapseStackFrames = (Boolean)event.getNewValue();
        }
    }

    public boolean isCollapseStackFrames() {
        return this.collapseStackFrames;
    }
}

