/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.products.emfforms.renderers;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.base.io.UserHomeProductResidence;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.loc.internal.api.OperatorGear;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.Keys;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.workbench.emfforms.renderers.FileContentRenderer;

public abstract class ProductVersionKeyRenderer
extends FileContentRenderer<ProductVersion> {
    protected final OperatorWorkspace workspace;

    @Inject
    public ProductVersionKeyRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, OperatorGearSupplier gear) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, ProductVersion.class);
        this.workspace = ((OperatorGear)gear.get()).workspace();
    }

    protected String extractFilePath(String value, ProductVersion observed) {
        BaseLicensedProduct product = new BaseLicensedProduct(observed.getProduct().getIdentifier(), observed.getVersion());
        Path dir = new Keys.Smart(this.workspace.keys()).existing((LicensedProduct)product).map(string -> Paths.get(string, new String[0])).map(Path::getParent).orElseGet((Supplier<Path>)new UserHomeProductResidence((LicensedProduct)product));
        return dir.resolve(new FileNameFromLicensedProduct((LicensedProduct)product, this::getFileExtension).get()).toString();
    }

    protected abstract String getFileExtension();
}

