/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.ActivePeriodField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.CapacityField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Field;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Fields;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.IpAddressField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LicenseDataPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LicensePlanField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.PortField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.ProductVersionField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.SwitchField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.UserField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.UsersField;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.workbench.MandatoryEclipseContext;
import org.eclipse.passage.loc.workbench.viewers.DomainRegistryLabelProvider;

public final class PageFields
implements Fields {
    private final List<Field<?>> units = new ArrayList();
    private final MandatoryService context;
    private final LabelProvider labels;
    private final Supplier<LicenseDataPage> page;

    PageFields(Supplier<LicenseDataPage> page, IEclipseContext context) {
        this.context = new MandatoryEclipseContext(context);
        this.labels = new DomainRegistryLabelProvider();
        this.page = page;
    }

    public Supplier<Optional<LicensePlan>> withLicensePlan(Optional<LicensePlan> plan) {
        return this.with(new LicensePlanField(plan, this::modified, this.labels, this.context));
    }

    public Supplier<Optional<User>> withUser(Optional<User> user) {
        return this.with(new UserField(user, this::modified, this.labels, this.context));
    }

    public Supplier<Optional<Collection<User>>> withUsers(List<User> users) {
        return this.with(new UsersField(users, this::modified, this.labels, this.context));
    }

    public Supplier<Optional<ProductVersion>> withProductVersion(Optional<ProductVersion> product) {
        return this.with(new ProductVersionField(product, this::modified, this.labels, this.context));
    }

    public Supplier<Optional<List<LocalDate>>> withPeriod() {
        return this.with(new ActivePeriodField(this::modified, this.labels, this.context));
    }

    public Supplier<Optional<Integer>> withDefaultCapacity() {
        return this.with(new CapacityField(IssueLicensePageMessages.IssueLicenseRequestPage_lbl_default_capacity, this::modified, this.labels, this.context));
    }

    public Supplier<Optional<Boolean>> withSwitcher(String field, boolean value) {
        return this.with(new SwitchField(field, value, this::modified, this.labels, this.context));
    }

    public Supplier<Optional<Integer>> withPort() {
        return this.with(new PortField(this::modified, this.labels, this.context));
    }

    public Supplier<Optional<String>> withIp() {
        return this.with(new IpAddressField(this::modified, this.labels, this.context));
    }

    private <T> Supplier<Optional<T>> with(Field<T> unit) {
        this.units.add(unit);
        return unit::data;
    }

    public void enable(boolean enable) {
        this.units.forEach(field -> field.enable(enable));
    }

    @Override
    public List<Field<?>> fields() {
        return this.units;
    }

    @Override
    public void modified() {
        this.page.get().validate();
    }
}

