/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicenseDomainRegistry;

public class LicensesDomainRegistryTracker
extends DomainContentAdapter<LicensePlan, LicenseDomainRegistry> {
    public LicensesDomainRegistryTracker(LicenseDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof LicensePlan) {
            LicensePlan licensePlan = (LicensePlan)notifier;
            switch (notification.getFeatureID(LicensePlan.class)) {
                case 0: {
                    this.processLicensePlanIdentifier(licensePlan, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processLicensePlanIdentifier(LicensePlan licensePlan, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((LicenseDomainRegistry)this.registry).unregisterLicensePlan(oldValue);
                }
                if (newValue == null) break;
                ((LicenseDomainRegistry)this.registry).registerLicensePlan(licensePlan);
                break;
            }
        }
    }
}

