/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.agreements.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.agreements.model.api.Agreement;
import org.eclipse.passage.lic.agreements.model.api.AgreementGroup;
import org.eclipse.passage.lic.agreements.model.meta.AgreementsPackage;
import org.eclipse.passage.lic.internal.agreements.model.util.AgreementsResourceImpl;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.agreements.core.AgreementsDomainRegistryTracker;
import org.eclipse.passage.loc.internal.agreements.core.i18n.AgreementsCoreMessages;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.Agreements;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.equinox.BaseDomainRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=agreements", "org.eclipse.passage.lic.emf.edit.file.extension=agreements_xmi"})
public final class AgreementDomainRegistry
extends BaseDomainRegistry<AgreementGroup>
implements AgreementRegistry,
EditingDomainRegistry<AgreementGroup> {
    private final Map<String, AgreementGroup> groups = new HashMap<String, AgreementGroup>();
    private final Map<String, Agreement> agreements = new HashMap<String, Agreement>();
    private final List<EventAdmin> events = new ArrayList<EventAdmin>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindEventAdmin(EventAdmin admin) {
        this.events.add(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events.remove(admin);
    }

    @Activate
    public void load(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void unload(Map<String, Object> properties) {
        this.agreements.clear();
        this.groups.clear();
        super.deactivate(properties);
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    public String getFileExtension() {
        return "agreements_xmi";
    }

    public Class<AgreementGroup> getContentClass() {
        return AgreementGroup.class;
    }

    public String resolveIdentifier(AgreementGroup content) {
        return content.getIdentifier();
    }

    @Override
    public Collection<AgreementGroup> groups() {
        return new ArrayList<AgreementGroup>(this.groups.values());
    }

    @Override
    public Optional<AgreementGroup> group(String identifier) {
        return Optional.ofNullable(this.groups.get(identifier));
    }

    @Override
    public Collection<Agreement> agreements() {
        return new ArrayList<Agreement>(this.agreements.values());
    }

    public Collection<Agreement> agreements(String id) {
        return this.group(id).map(AgreementGroup::getAgreements).orElseGet(BasicEList::new).stream().toList();
    }

    @Override
    public Optional<Agreement> agreement(String identifier) {
        return Optional.ofNullable(this.agreements.get(identifier));
    }

    protected DomainContentAdapter<AgreementGroup, AgreementDomainRegistry> createContentAdapter() {
        return new AgreementsDomainRegistryTracker(this);
    }

    public void registerAgreementGroup(AgreementGroup group) {
        AgreementGroup existing = this.groups.put(group.getIdentifier(), group);
        if (existing != null && existing != group) {
            String msg = NLS.bind((String)AgreementsCoreMessages.AgreementDomain_instance_duplication_message, (Object)existing, (Object)group);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.brush(group);
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/AgreementGroup/create", (Object)group).get());
        group.getAgreements().forEach(u -> this.registerAgreement((Agreement)u));
    }

    private void brush(AgreementGroup group) {
        if (group.getDescription() == null) {
            group.setDescription("");
        }
    }

    public void registerAgreement(Agreement agreement) {
        String identifier = agreement.getIdentifier();
        Agreement existing = this.agreements.put(identifier, agreement);
        if (existing != null && existing != agreement) {
            String msg = NLS.bind((String)AgreementsCoreMessages.AgreementDomain_instance_duplication_message, (Object)existing, (Object)agreement);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/Agreement/create", (Object)agreement).get());
    }

    public void unregisterAgreementGroup(String id) {
        AgreementGroup removed = this.groups.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/AgreementGroup/delete", (Object)removed).get());
            removed.getAgreements().forEach(u -> this.unregisterAgreement(u.getIdentifier()));
        }
    }

    public void unregisterAgreement(String id) {
        Agreement removed = this.agreements.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/Agreement/delete", (Object)removed).get());
        }
    }

    private EventAdmin events() {
        return (EventAdmin)this.events.stream().findAny().get();
    }

    public EClass getContentClassifier() {
        return AgreementsPackage.eINSTANCE.getAgreementGroup();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return AgreementsPackage.eINSTANCE.getAgreementGroup_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return AgreementsPackage.eINSTANCE.getAgreementGroup_Name();
    }

    public void registerContent(AgreementGroup content) {
        this.registerAgreementGroup(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterAgreementGroup(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new AgreementsResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Agreements.xmi.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.agreements();
    }
}

