/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.yars.internal.api;

import java.util.List;
import org.eclipse.passage.loc.yars.internal.api.DosHandleMedia;
import org.eclipse.passage.loc.yars.internal.api.ExportData;
import org.eclipse.passage.loc.yars.internal.api.FetchedData;
import org.eclipse.passage.loc.yars.internal.api.Progress;
import org.eclipse.passage.loc.yars.internal.api.Storage;

public final class SingleSwoopExport<S extends Storage<?>, T extends ExportData<T, DosHandleMedia<T>>>
implements ExportData<T, DosHandleMedia<T>> {
    private final FetchedData<S, T> query;

    public SingleSwoopExport(FetchedData<S, T> query) {
        this.query = query;
    }

    @Override
    public void write(DosHandleMedia<T> media, Progress<T> progress) {
        media.start();
        this.writeData(media, progress);
        media.finish();
    }

    private void writeData(DosHandleMedia<T> media, Progress<T> progress) {
        List<T> fetch = this.query.get();
        progress.estimate(fetch.size());
        for (ExportData data : fetch) {
            if (progress.cancelDemanded()) break;
            progress.reportNodeSrart(data);
            media.startNode(data);
            data.write(media, progress);
            media.finishNode(data);
            progress.reportNodeFinish(data);
        }
    }
}

