/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.loc.internal.products.core.ProductKeys;

public final class PublicKeyReplcated {
    private final LicensedProduct product;
    public final Path folder;

    public PublicKeyReplcated(LicensedProduct product, Path folder) {
        this.product = product;
        this.folder = folder;
    }

    public Path store() throws IOException, LicensingException {
        Path destination = this.folder.resolve(new FileNameFromLicensedProduct(this.product, (PassageFileExtension)new PassageFileExtension.PublicKey()).get());
        if (Files.exists(destination, new LinkOption[0])) {
            return destination;
        }
        Files.write(destination, new ProductKeys(this.product).pubBytes(), StandardOpenOption.CREATE_NEW);
        return destination;
    }
}

