/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.internal.emf.EObjectToBytes;
import org.eclipse.passage.lic.keys.model.api.KeyPair;
import org.eclipse.passage.loc.internal.api.workspace.Keys;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.equinox.OperatorGearAware;
import org.eclipse.passage.loc.internal.products.core.ProductKeys;

public final class KeyPairStored {
    private final KeyPair pair;

    public KeyPairStored(KeyPair pair) {
        this.pair = pair;
    }

    public Optional<String> store() throws LicensingException {
        return new OperatorGearAware().withGear(gear -> this.store(gear.workspace().keys()));
    }

    private Optional<String> store(Keys keys) throws LicensingException {
        String product = this.pair.getProduct().getIdentifier();
        String version = this.pair.getProduct().getVersion();
        ResourceHandle locator = this.storeCoupled(keys, product, version);
        this.storePublic(keys, product, version);
        return Optional.of(locator.info());
    }

    private ResourceHandle storeCoupled(Keys keys, String product, String version) throws LicensingException {
        ResourceHandle locator = keys.located(product, version);
        byte[] content = new EObjectToBytes((EObject)this.pair).get();
        try {
            locator.write(content);
        }
        catch (Exception e) {
            throw new LicensingException(String.format("Failed to store keys for %s %s", product, version), (Throwable)e);
        }
        return locator;
    }

    private void storePublic(Keys keys, String product, String version) throws LicensingException {
        ResourceHandle locator = keys.locatedPub(product, version);
        try {
            locator.write(new ProductKeys(product, version).pubBytes());
        }
        catch (Exception e) {
            throw new LicensingException("Failed to store public key", (Throwable)e);
        }
    }
}

