/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.keys.model.api.KeyPair;
import org.eclipse.passage.lic.keys.model.api.ProductRef;
import org.eclipse.passage.lic.keys.model.meta.KeysFactory;

final class KeyPairGeneraged
implements Supplier<KeyPair> {
    private final StreamCodec author;
    private final byte[] pub;
    private final byte[] scr;

    KeyPairGeneraged(StreamCodec author, byte[] pub, byte[] scr) {
        this.author = author;
        this.pub = pub;
        this.scr = scr;
    }

    @Override
    public KeyPair get() {
        KeyPair pair = KeysFactory.eINSTANCE.createKeyPair();
        pair.setProduct(this.product());
        pair.setAlgorithm(this.author.algorithm().name());
        pair.setKey(this.author.keySize().size());
        pair.setPub(new String(this.pub));
        pair.setScr(new String(this.scr));
        return pair;
    }

    private ProductRef product() {
        ProductRef product = KeysFactory.eINSTANCE.createProductRef();
        product.setIdentifier(((LicensedProduct)this.author.id()).identifier());
        product.setVersion(((LicensedProduct)this.author.id()).version());
        return product;
    }
}

