/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.io.LicensingFolder;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.base.io.UserHomePath;
import org.eclipse.passage.lic.keys.model.api.KeyPair;
import org.eclipse.passage.loc.internal.products.core.ConvertKeysReport;
import org.eclipse.passage.loc.internal.products.core.KeyPairStored;
import org.eclipse.passage.loc.internal.products.core.KeyPairUpgraded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConvertedKeys {
    private final String ext = new PassageFileExtension.PublicKey().get();
    private final Consumer<ConvertKeysReport> exposure;

    public ConvertedKeys(Consumer<ConvertKeysReport> exposure) {
        this.exposure = exposure;
    }

    public ConvertedKeys() {
        this(new ToLog());
    }

    public void persist() {
        Stream<Path> files;
        Path root = new LicensingFolder(new UserHomePath().get()).get();
        try {
            files = Files.walk(root, new FileVisitOption[0]);
        }
        catch (IOException e) {
            this.exposure.accept(this.failedToScan(root, e));
            return;
        }
        this.exposure.accept(new ConvertKeysReport(files.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(this::isPublicKey).map(this::convert).collect(Collectors.toList())));
    }

    private boolean isPublicKey(Path file) {
        return file.toString().endsWith(this.ext);
    }

    private ConvertKeysReport.Record convert(Path pub) {
        Optional<String> locator;
        KeyPair pair;
        Optional<LicensedProduct> product = this.product(pub);
        if (product.isEmpty()) {
            return this.noProduct(pub);
        }
        Optional<Path> scr = this.scr(pub);
        if (scr.isEmpty()) {
            return this.noPair(pub);
        }
        try {
            pair = new KeyPairUpgraded(product.get(), pub, scr.get()).get();
        }
        catch (IOException e) {
            return new ConvertKeysReport.ErrorOnKeyReading(pub.getParent(), this.keyName(pub), e);
        }
        try {
            locator = new KeyPairStored(pair).store();
        }
        catch (LicensingException e) {
            return new ConvertKeysReport.ErrorOnKeyStoring(pub.getParent(), this.keyName(pub), e);
        }
        return new ConvertKeysReport.Success(pub.getParent(), this.keyName(pub), locator);
    }

    private String keyName(Path pub) {
        String path = pub.getFileName().toString();
        return path.substring(0, path.length() - this.ext.length());
    }

    private ConvertKeysReport failedToScan(Path dir, IOException e) {
        return new ConvertKeysReport(new ConvertKeysReport.ErrorOnScan(dir, e));
    }

    private ConvertKeysReport.Record noProduct(Path pub) {
        return new ConvertKeysReport.NoProduct(pub);
    }

    private ConvertKeysReport.Record noPair(Path pub) {
        return new ConvertKeysReport.ScrNotFound(pub);
    }

    private Optional<Path> scr(Path pub) {
        Path scr = pub.getParent().resolve(this.keyName(pub) + new PassageFileExtension.PrivateKey().get());
        return Files.exists(scr, new LinkOption[0]) && Files.isRegularFile(scr, new LinkOption[0]) ? Optional.of(scr) : Optional.empty();
    }

    private Optional<LicensedProduct> product(Path pub) {
        String name = this.keyName(pub);
        int separator = name.lastIndexOf(95);
        if (separator < 0 || separator >= name.length()) {
            return this.productFromFolders(pub);
        }
        return Optional.of(new BaseLicensedProduct(name.substring(0, separator), name.substring(separator + 1)));
    }

    private Optional<LicensedProduct> productFromFolders(Path pub) {
        if (pub.getParent().getParent() == null) {
            return Optional.empty();
        }
        return Optional.of(new BaseLicensedProduct(pub.getParent().getParent().getFileName().toString(), pub.getParent().getFileName().toString()));
    }

    static final class ToLog
    implements Consumer<ConvertKeysReport> {
        private final Logger log = LoggerFactory.getLogger(ConvertedKeys.class);

        ToLog() {
        }

        @Override
        public void accept(ConvertKeysReport report) {
            report.records().forEach(this::print);
        }

        private void print(ConvertKeysReport.Record record) {
            this.log.info(String.format("%s || %s", record.origin().toAbsolutePath(), record.message()));
        }
    }
}

