/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.agreements.emfforms.renderers;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

final class AgreementFormat {
    private final String extention;
    private final String description;
    private final String mime;

    AgreementFormat(String name, String extention, String mime) {
        this.extention = name;
        this.description = extention;
        this.mime = mime;
    }

    String extention() {
        return this.extention;
    }

    String description() {
        return this.description;
    }

    String name() {
        return String.valueOf('*') + this.extention;
    }

    String mime() {
        return this.mime;
    }

    static class Supported
    implements Supplier<List<AgreementFormat>> {
        private final List<AgreementFormat> supported = Arrays.asList(new AgreementFormat(".txt", "Text file (*.txt)", "text/plain"));

        Supported() {
        }

        @Override
        public List<AgreementFormat> get() {
            return this.supported;
        }

        public Optional<AgreementFormat> forFile(String name) {
            return this.supported.stream().filter(format -> name.endsWith(format.extention)).findAny();
        }
    }
}

