/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.agreements.emfforms.renderers;

import java.io.File;
import java.nio.file.Files;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IDecoratingObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.passage.lic.agreements.model.api.Agreement;
import org.eclipse.passage.loc.agreements.emfforms.renderers.AgreementFormat;
import org.eclipse.passage.loc.agreements.emfforms.renderers.LocatedAgreementFile;
import org.eclipse.passage.loc.internal.equinox.AgreementsService;
import org.eclipse.passage.loc.workbench.emfforms.renderers.TextWithButtonRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class AgreementFileRenderer
extends TextWithButtonRenderer {
    @Inject
    public AgreementFileRenderer(VControl element, ViewModelContext context, ReportService report, EMFFormsDatabinding databinding, EMFFormsLabelProvider labeling, VTViewTemplateProvider template) {
        super(element, context, report, databinding, labeling, template);
    }

    protected Control createSWTControl(Composite parent) {
        Control control = super.createSWTControl(parent);
        this.text.setEditable(false);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgreementFileRenderer.this.locateAgreementContentFile();
            }
        });
        this.button.setText("Agreement Content File...");
        return control;
    }

    protected String getUnsetText() {
        return "";
    }

    protected void locateAgreementContentFile() {
        Object file = new LocatedAgreementFile().get();
        if (((Optional)file).isEmpty()) {
            return;
        }
        try {
            this.reflect(this.reside((File)((Optional)file).get()));
        }
        catch (Exception e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
        }
    }

    private String reside(File file) throws Exception {
        String name = file.getName();
        new AgreementsService().get().located(name).write(Files.readAllBytes(file.toPath()));
        return name;
    }

    private void reflect(String name) {
        if (this.definedName().orElse("").equals(name)) {
            return;
        }
        this.reflectFileName(name);
        this.reflectMimeType(name);
    }

    private void reflectFileName(String name) {
        this.text.setText(name);
    }

    private void reflectMimeType(String name) {
        Optional<AgreementFormat> format = new AgreementFormat.Supported().forFile(name);
        if (format.isEmpty()) {
            return;
        }
        this.agreement().ifPresent(agreement -> agreement.setMime(((AgreementFormat)format.get()).mime()));
    }

    private Optional<String> definedName() {
        try {
            Object value = this.getModelValue().getValue();
            if (!String.class.isInstance(value)) {
                return Optional.empty();
            }
            String name = (String)value;
            return Optional.of(name);
        }
        catch (DatabindingFailedException e) {
            return Optional.empty();
        }
    }

    private Optional<Agreement> agreement() {
        try {
            IObservableValue value = this.getModelValue();
            if (!IDecoratingObservable.class.isInstance(value)) {
                return Optional.empty();
            }
            IObservable decorated = ((IDecoratingObservable)value).getDecorated();
            if (!IObserving.class.isInstance(decorated)) {
                return Optional.empty();
            }
            Object source = ((IObserving)decorated).getObserved();
            if (!Agreement.class.isInstance(source)) {
                return Optional.empty();
            }
            return Optional.of((Agreement)source);
        }
        catch (DatabindingFailedException e) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)e));
            return Optional.empty();
        }
    }
}

