# Contributing to Tern

## Submitting bug reports

The preferred way to report bugs is to use the [GitHub issue
tracker](http://github.com/codemirror/tern/issues). Please put some
thought and energy into your report, to make it easy for us to help
you.

- Describe very precisely what went wrong. "X is broken" is not a good bug
  report. What did you expect to happen? What happened instead?

- Provide a way for the maintainer to reproduce the problem you are
  seeing. That sometimes means waiting for a problem to occur a second
  time, and experimenting to see exactly which circumstances trigger
  the problem. We can rarely fix bugs that we can not reproduce.

- Reduce your instructions for reproducing the bug as much as
  possible. The more irrelevant pieces (code, steps) are included, the
  more time we'll have to waste going through them.

- Mention which exact version (release number or, if you got the code
  from git, revision hash) of Tern you are using. Include your project
  configuration if there is any chance of it being relevant.

- Be civil. The project is maintained by volunteers who do not owe you
  anything. Reports with an indignant or belligerent tone tend to be
  moved to the bottom of the pile.

## Contributing code

The preferred way to contribute code is through GitHub pull requests.

If you plan to do something major, please discuss it on the [mailing
list](https://groups.google.com/forum/?fromgroups#!forum/tern-dev)
first, to avoid wasting time on something that will not be merged.

Follow the project's general coding style. Patches that randomly
change code to your preferred coding style or reorganize code for
subjective reasons will not be accepted.

By contributing code to Tern you

 - agree to license the contributed code under Tern's [MIT
   license](http://ternjs.net/LICENSE).

 - confirm that you have the right to contribute and license the code
   in question. (Either you hold all rights on the code, or the rights
   holder has explicitly granted the right to use it like this,
   through a compatible open source license or through a direct
   agreement with you.)
