/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.jetty;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.jetty.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class WebApplication
implements IApplication {
    private static final String EQUINOX_HTTP_JETTY = "org.eclipse.equinox.http.jetty";
    private static final String EQUINOX_HTTP_REGISTRY = "org.eclipse.equinox.http.registry";
    private static final String JETTY = "jetty";
    private static final String HTTP_PORT = "jetty.http.port";
    private static final String HTTPS_ENABLED = "jetty.https.enabled";
    private static final String HTTPS_PORT = "jetty.https.port";
    private static final String SSL_KEYPASSWORD = "jetty.ssl.keypassword";
    private static final String SSL_KEYSTORE = "jetty.ssl.keystore";
    private static final String SSL_PASSWORD = "jetty.ssl.password";
    private static final String SSL_PROTOCOL = "jetty.ssl.protocol";
    private IApplicationContext appContext;

    private void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = Activator.getBundle(symbolicName);
        if (bundle != null && (bundle.getState() == 4 || bundle.getState() == 8)) {
            bundle.start(1);
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        Boolean jettyAccessLogsEnabled;
        this.appContext = context;
        this.ensureBundleStarted(EQUINOX_HTTP_JETTY);
        this.ensureBundleStarted(EQUINOX_HTTP_REGISTRY);
        IEclipsePreferences preferences = DefaultScope.INSTANCE.getNode("org.eclipse.orion.server.core");
        Boolean httpsEnabled = new Boolean(preferences.get(HTTPS_ENABLED, "false"));
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("context.sessioninactiveinterval", new Integer(14400));
        String contextPath = preferences.get("orion.context.path", null);
        if (contextPath != null) {
            ((Dictionary)properties).put("context.path", contextPath);
        }
        if ((jettyAccessLogsEnabled = new Boolean(preferences.get("orion.jetty.access.logs.enable", "false"))).booleanValue()) {
            ((Dictionary)properties).put("customizer.class", "org.eclipse.orion.server.jettycustomizer.OrionJettyCustomizer");
        }
        if (httpsEnabled.booleanValue()) {
            LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.jetty", "Https is enabled", null));
            ((Dictionary)properties).put("https.enabled", true);
            ((Dictionary)properties).put("https.port", new Integer(preferences.get(HTTPS_PORT, System.getProperty("org.eclipse.equinox.http.jetty.https.port", "8443"))));
            ((Dictionary)properties).put("ssl.keystore", preferences.get(SSL_KEYSTORE, "keystore"));
            LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.jetty", "Keystore absolute path is " + preferences.get(SSL_KEYSTORE, "keystore")));
            ((Dictionary)properties).put("ssl.password", preferences.get(SSL_PASSWORD, "password"));
            ((Dictionary)properties).put("ssl.keypassword", preferences.get(SSL_KEYPASSWORD, "password"));
            ((Dictionary)properties).put("ssl.protocol", preferences.get(SSL_PROTOCOL, "SSLv3"));
            String httpsHost = System.getProperty("org.eclipse.equinox.http.jetty.https.host");
            if (httpsHost != null) {
                ((Dictionary)properties).put("https.host", httpsHost);
            }
        }
        String port = null;
        if (!httpsEnabled.booleanValue()) {
            ((Dictionary)properties).put("http.enabled", true);
            port = preferences.get(HTTP_PORT, System.getProperty("org.eclipse.equinox.http.jetty.http.port", "8080"));
            ((Dictionary)properties).put("http.port", new Integer(port));
            String httpHost = System.getProperty("org.eclipse.equinox.http.jetty.http.host");
            if (httpHost != null) {
                ((Dictionary)properties).put("http.host", httpHost);
            }
        }
        ((Dictionary)properties).put("other.info", "org.eclipse.orion");
        try {
            JettyConfigurator.startServer((String)"MasterJetty", properties);
        }
        catch (Exception e) {
            throw new Exception("Error starting Jetty on port: " + port, e);
        }
        if (this.appContext != null) {
            this.appContext.applicationRunning();
        }
        return IApplicationContext.EXIT_ASYNC_RESULT;
    }

    public void stop() {
        try {
            JettyConfigurator.stopServer((String)"MasterJetty");
        }
        catch (Exception exception) {}
        if (this.appContext != null) {
            this.appContext.setResult((Object)EXIT_OK, (IApplication)this);
        }
    }
}

