/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.objects;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.logs.objects.RollingFileAppenderResource;
import org.json.JSONObject;

@ResourceDescription(type="ArchivedLogFile")
public class ArchivedLogFileResource {
    public static final String RESOURCE = "archivedLogFile";
    public static final String TYPE = "ArchivedLogFile";
    protected static ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Serializer<JSONObject> jsonSerializer;
    protected URI baseLocation;
    protected String name;
    protected RollingFileAppenderResource rollingFileAppender;

    public ArchivedLogFileResource(RollingFileAppenderResource rollingFileAppender, File logFile) {
        Property[] defaultProperties = new Property[]{new Property("Name"), new Property("Location"), new Property("RollingFileAppenderLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.jsonSerializer = new JSONSerializer();
        this.rollingFileAppender = rollingFileAppender;
        this.baseLocation = rollingFileAppender.baseLocation;
        this.name = logFile.getName();
    }

    @PropertyDescription(name="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RollingFileAppenderResource getRollingFileAppender() {
        return this.rollingFileAppender;
    }

    public void setRollingFileAppender(RollingFileAppenderResource rollingFileAppender) {
        this.rollingFileAppender = rollingFileAppender;
    }

    protected URI createUriWithPath(IPath path) throws URISyntaxException {
        return new URI(this.baseLocation.getScheme(), this.baseLocation.getUserInfo(), this.baseLocation.getHost(), this.baseLocation.getPort(), path.toString(), this.baseLocation.getQuery(), this.baseLocation.getFragment());
    }

    public JSONObject toJSON() throws URISyntaxException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    public void setBaseLocation(URI baseLocation) {
        this.baseLocation = baseLocation;
    }

    @PropertyDescription(name="RollingFileAppenderLocation")
    public URI getRollingFileAppenderLocation() throws URISyntaxException {
        return this.getRollingFileAppender().getLocation();
    }

    @PropertyDescription(name="Location")
    public URI getLocation() throws URISyntaxException {
        IPath path = new Path("/logapi").append("rollingFileAppender").append(this.getRollingFileAppender().getName()).append(this.getName());
        return this.createUriWithPath(path);
    }
}

