/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class EndingAwareLineReader
extends BufferedReader {
    private LineDelimiter lineDelimiter = null;
    private String line = null;
    private StringBuilder lineBuilder = new StringBuilder();

    public EndingAwareLineReader(Reader in) {
        super(in);
    }

    @Override
    public String readLine() throws IOException {
        char first = '0';
        while (true) {
            if ((first = (char)((char)this.read())) == '\uffff') {
                if (this.lineBuilder.length() == 0) {
                    return null;
                }
                this.line = this.lineBuilder.toString();
                this.lineDelimiter = LineDelimiter.EMPTY;
                this.lineBuilder.setLength(0);
                return this.line;
            }
            if (first == '\n') {
                this.line = this.lineBuilder.toString();
                this.lineDelimiter = LineDelimiter.LF;
                this.lineBuilder.setLength(0);
                return this.line;
            }
            if (first == '\r') {
                char second = (char)this.read();
                if (second == '\uffff') {
                    this.line = this.lineBuilder.toString();
                    this.lineDelimiter = LineDelimiter.CR;
                    this.lineBuilder.setLength(0);
                    return this.line;
                }
                if (second == '\n') {
                    this.line = this.lineBuilder.toString();
                    this.lineDelimiter = LineDelimiter.CRLF;
                    this.lineBuilder.setLength(0);
                    return this.line;
                }
                this.line = this.lineBuilder.toString();
                this.lineDelimiter = LineDelimiter.CR;
                this.lineBuilder.setLength(0);
                this.lineBuilder.append(second);
                return this.line;
            }
            this.lineBuilder.append(first);
        }
    }

    public LineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public static enum LineDelimiter {
        LF("\n"),
        CR("\r"),
        CRLF("\r\n"),
        EMPTY("");

        private final String lineDelimiter;

        private LineDelimiter(String ld) {
            this.lineDelimiter = ld;
        }

        public String toString() {
            return this.lineDelimiter;
        }
    }
}

