/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.orion.internal.server.core.diskusage.DiskUsageJob;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStore;
import org.eclipse.orion.internal.server.core.tasks.TaskService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static volatile BundleContext bundleContext;
    private static Activator singleton;
    private ServiceTracker<IPreferencesService, IPreferencesService> prefTracker;
    private ServiceRegistration<ITaskService> taskServiceRegistration;
    private ITaskService taskService;
    private IMetaStore metastore;
    private URI rootStoreURI;
    private DiskUsageJob diskUsageJob;
    private static final Logger logger;
    private ServiceTracker<Location, Location> instanceLocationTracker;

    static {
        logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
    }

    public static Activator getDefault() {
        return singleton;
    }

    public synchronized IMetaStore getMetastore() {
        return this.metastore;
    }

    public static IPreferencesService getPreferenceService() {
        Activator a = singleton;
        if (a == null) {
            return null;
        }
        ServiceTracker<IPreferencesService, IPreferencesService> tracker = a.getPrefTracker();
        if (tracker == null) {
            return null;
        }
        return (IPreferencesService)tracker.getService();
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private ServiceTracker<IPreferencesService, IPreferencesService> getPrefTracker() {
        if (this.prefTracker != null) {
            return this.prefTracker;
        }
        if (bundleContext == null) {
            return null;
        }
        this.prefTracker = new ServiceTracker(bundleContext, IPreferencesService.class, null);
        this.prefTracker.open();
        return this.prefTracker;
    }

    private IPath getTaskLocation() throws IOException {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            throw new IOException("Framework instance location is undefined");
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                throw new IOException("Framework instance location is undefined");
            }
            URL root = location.getDataArea("org.eclipse.orion.server.core");
            IPath iPath = new Path(root.toExternalForm().substring(5)).append("tasks");
            return iPath;
        }
        finally {
            context.ungetService(ref);
        }
    }

    private void initializeMetaStore() {
        try {
            this.metastore = new SimpleMetaStore(OrionConfiguration.getRootLocation().toLocalFile(0, null));
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("UserName");
            this.metastore.registerUserProperties(keys);
            this.metastore.readAllUsers();
        }
        catch (CoreException e) {
            String msg = "Cannot initialize MetaStore";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        bundleContext.registerService(IMetaStore.class, (Object)this.metastore, null);
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.registerServices();
        this.initializeFileSystem();
        this.initializeMetaStore();
        this.startDiskUsageJob();
    }

    private void startDiskUsageJob() {
        String diskUsageEnabled = PreferenceHelper.getString("orion.file.diskUsageEnabled", "false").toLowerCase();
        if ("true".equals(diskUsageEnabled)) {
            this.diskUsageJob = new DiskUsageJob();
            this.diskUsageJob.schedule(10000L);
        }
    }

    private void registerServices() {
        try {
            IPath taskLocation = this.getTaskLocation();
            this.taskService = new TaskService(taskLocation);
            this.taskServiceRegistration = bundleContext.registerService(ITaskService.class, (Object)this.taskService, null);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Failed to initialize task service", (Throwable)e));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.metastore = null;
        this.stopTaskService();
        if (this.prefTracker != null) {
            this.prefTracker.close();
            this.prefTracker = null;
        }
        bundleContext = null;
    }

    public IPath getPlatformLocation() {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                return null;
            }
            URL root = location.getURL();
            if (root == null) {
                return null;
            }
            Path path = new Path(root.toExternalForm().substring(5));
            return path;
        }
        finally {
            context.ungetService(ref);
        }
    }

    private void initializeFileSystem() {
        IPath location = this.getFileSystemLocation();
        if (location == null) {
            RuntimeException e = new RuntimeException("Unable to compute base file system location");
            logger.error("Failed to initialize server file system", (Throwable)e);
            throw e;
        }
        IFileStore rootStore = EFS.getLocalFileSystem().getStore(location);
        try {
            rootStore.mkdir(0, null);
            this.rootStoreURI = rootStore.toURI();
        }
        catch (CoreException e) {
            String msg = "Instance location is read only: " + rootStore;
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private IPath getFileSystemLocation() {
        this.ensureBundleStarted("org.eclipse.equinox.registry");
        String locationPref = PreferenceHelper.getString("orion.file.content.location");
        if (locationPref != null) {
            return new Path(locationPref);
        }
        return this.getPlatformLocation();
    }

    private void stopTaskService() {
        ServiceRegistration<ITaskService> reg = this.taskServiceRegistration;
        this.taskServiceRegistration = null;
        this.taskService = null;
        if (reg != null) {
            reg.unregister();
        }
    }

    public URI getRootLocationURI() {
        return this.rootStoreURI;
    }

    private void ensureBundleStarted(String symbolicName) {
        Bundle bundle = this.getBundle(symbolicName);
        if (bundle != null && (bundle.getState() == 4 || bundle.getState() == 8)) {
            try {
                bundle.start(1);
            }
            catch (BundleException e) {
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.core");
                logger.error("Could not start bundle " + symbolicName, (Throwable)e);
            }
        }
    }

    private Bundle getBundle(String symbolicName) {
        Bundle[] bundleArray = this.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (symbolicName.equals(bundle.getSymbolicName())) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    Location getInstanceLocation() {
        if (this.instanceLocationTracker == null) {
            Filter filter;
            try {
                filter = bundleContext.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException e) {
                LogHelper.log(e);
                return null;
            }
            this.instanceLocationTracker = new ServiceTracker(bundleContext, filter, null);
            this.instanceLocationTracker.open();
        }
        return (Location)this.instanceLocationTracker.getService();
    }

    String getProperty(String key) {
        return bundleContext.getProperty(key);
    }
}

