/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.internal.series.MarkerSeries;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;

public class Cursor
implements MouseMotionListener {
    private static final int LINE_SPACING = 5;
    private static final int MOUSE_SPACING = 15;
    private final List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    private final List<DataPoint> matchingDataPointList = new ArrayList<DataPoint>();
    private final Styler styler;
    private Rectangle2D bounds;
    private Map<String, Series> seriesMap;
    private double mouseX;
    private double mouseY;
    private double startX;
    private double startY;
    private double textHeigh;

    Cursor(Styler styler) {
        this.styler = styler;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.styler.isCursorEnabled() || this.seriesMap == null) {
            return;
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (this.isMouseOut()) {
            if (this.matchingDataPointList.size() > 0) {
                this.matchingDataPointList.clear();
                e.getComponent().repaint();
            }
            return;
        }
        e.getComponent().repaint();
    }

    public void paint(Graphics2D g) {
        if (!this.styler.isCursorEnabled()) {
            return;
        }
        this.calculateMatchingDataPoints();
        if (this.matchingDataPointList.size() > 0) {
            DataPoint firstDataPoint = this.matchingDataPointList.get(0);
            TextLayout xValueTextLayout = new TextLayout(firstDataPoint.xValue, this.styler.getCursorFont(), new FontRenderContext(null, true, false));
            this.textHeigh = xValueTextLayout.getBounds().getHeight();
            this.paintVerticalLine(g, firstDataPoint);
            this.paintBackGround(g, xValueTextLayout);
            this.painDataPointInfo(g, xValueTextLayout);
        }
    }

    private void paintVerticalLine(Graphics2D g, DataPoint dataPoint) {
        BasicStroke stroke = new BasicStroke(this.styler.getCursorSize(), 0, 0);
        g.setStroke(stroke);
        g.setColor(this.styler.getCursorColor());
        Line2D.Double line = new Line2D.Double();
        line.setLine(dataPoint.x, this.bounds.getY(), dataPoint.x, this.bounds.getY() + this.bounds.getHeight());
        g.draw(line);
    }

    private void paintBackGround(Graphics2D g, TextLayout xValueTextLayout) {
        double maxLinewidth = xValueTextLayout.getBounds().getWidth();
        TextLayout dataPointTextLayout = null;
        Rectangle2D dataPointRectangle = null;
        for (DataPoint dataPoint : this.matchingDataPointList) {
            dataPointTextLayout = new TextLayout(dataPoint.seriesName + ": " + dataPoint.yValue, this.styler.getCursorFont(), new FontRenderContext(null, true, false));
            dataPointRectangle = dataPointTextLayout.getBounds();
            if (!(maxLinewidth < dataPointRectangle.getWidth())) continue;
            maxLinewidth = dataPointRectangle.getWidth();
        }
        double backgroundWidth = (double)this.styler.getCursorFont().getSize() + maxLinewidth + 15.0;
        double backgroundHeight = this.textHeigh * (double)(1 + this.matchingDataPointList.size()) + (double)((2 + this.matchingDataPointList.size()) * 5);
        this.startX = this.mouseX;
        this.startY = this.mouseY;
        if (this.mouseX + 15.0 + backgroundWidth > this.bounds.getX() + this.bounds.getWidth()) {
            this.startX = this.mouseX - backgroundWidth - 15.0;
        }
        if (this.mouseY + 15.0 + backgroundHeight > this.bounds.getY() + this.bounds.getHeight()) {
            this.startY = this.mouseY - backgroundHeight - 15.0;
        }
        g.setColor(this.styler.getCursorBackgroundColor());
        g.fillRect((int)this.startX + 15, (int)this.startY + 15, (int)backgroundWidth, (int)backgroundHeight);
    }

    private void painDataPointInfo(Graphics2D g, TextLayout xValueTextLayout) {
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(this.startX + 15.0 + 5.0, this.startY + this.textHeigh + 15.0 + 5.0);
        g.transform(at);
        g.setColor(this.styler.getCursorFontColor());
        g.fill(xValueTextLayout.getOutline(null));
        MarkerSeries series = null;
        TextLayout dataPointTextLayout = null;
        Ellipse2D.Double circle = null;
        for (DataPoint dataPoint : this.matchingDataPointList) {
            at = new AffineTransform();
            at.translate(0.0, this.textHeigh + 5.0);
            g.transform(at);
            series = (MarkerSeries)this.seriesMap.get(dataPoint.seriesName);
            g.setColor(series.getMarkerColor());
            circle = new Ellipse2D.Double(0.0, -this.textHeigh, this.textHeigh, this.textHeigh);
            g.fill(circle);
            at = new AffineTransform();
            at.translate(this.textHeigh + 5.0, 0.0);
            g.transform(at);
            g.setColor(this.styler.getCursorFontColor());
            dataPointTextLayout = new TextLayout(dataPoint.seriesName + ": " + dataPoint.yValue, this.styler.getCursorFont(), new FontRenderContext(null, true, false));
            g.fill(dataPointTextLayout.getOutline(null));
            at = new AffineTransform();
            at.translate(-this.textHeigh - 5.0, 0.0);
            g.transform(at);
        }
        g.setTransform(orig);
    }

    void prepare(Rectangle2D bounds, Map<String, Series> seriesMap) {
        if (!this.styler.isCursorEnabled()) {
            return;
        }
        this.dataPointList.clear();
        this.bounds = bounds;
        this.seriesMap = seriesMap;
    }

    void addData(double xOffset, double yOffset, String xValue, String yValue, String seriesName) {
        DataPoint dataPoint = new DataPoint(xOffset, yOffset, xValue, yValue, seriesName);
        this.dataPointList.add(dataPoint);
    }

    private boolean isMouseOut() {
        boolean isMouseOut = false;
        if (!this.bounds.contains(this.mouseX, this.mouseY)) {
            isMouseOut = true;
        }
        return isMouseOut;
    }

    private void calculateMatchingDataPoints() {
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        for (DataPoint dataPoint : this.dataPointList) {
            if (!dataPoint.shape.contains(this.mouseX, dataPoint.shape.getBounds().getCenterY()) || !(this.bounds.getY() < this.mouseY) || !(this.bounds.getY() + this.bounds.getHeight() > this.mouseY)) continue;
            dataPoints.add(dataPoint);
        }
        if (dataPoints.size() > 0) {
            HashMap<String, DataPoint> map = new HashMap<String, DataPoint>();
            String seriesName = "";
            for (DataPoint dataPoint : dataPoints) {
                seriesName = dataPoint.seriesName;
                if (map.containsKey(seriesName)) {
                    if (!(Math.abs(dataPoint.x - this.mouseX) < Math.abs(((DataPoint)map.get((Object)seriesName)).x - this.mouseX))) continue;
                    map.put(seriesName, dataPoint);
                    continue;
                }
                map.put(seriesName, dataPoint);
            }
            this.matchingDataPointList.clear();
            this.matchingDataPointList.addAll(map.values());
        }
    }

    private class DataPoint {
        private static final int MARGIN = 5;
        final Shape shape;
        final double x;
        final double y;
        final String xValue;
        final String yValue;
        final String seriesName;

        public DataPoint(double x, double y, String xValue, String yValue, String seriesName) {
            double halfSize = 7.5;
            double markerSize = 15.0;
            this.x = x;
            this.y = y;
            this.shape = new Ellipse2D.Double(this.x - halfSize, this.y - halfSize, markerSize, markerSize);
            this.xValue = xValue;
            this.yValue = yValue;
            this.seriesName = seriesName;
        }
    }
}

