/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import org.knowm.xchart.RadarChartBuilder;
import org.knowm.xchart.RadarSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.InfoPanel;
import org.knowm.xchart.internal.chartpart.Legend_Pie;
import org.knowm.xchart.internal.chartpart.Plot_Radar;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.RadarStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class RadarChart
extends Chart<RadarStyler, RadarSeries> {
    protected String[] variableLabels;
    private RadarRenderStyle radarRenderStyle = RadarRenderStyle.Polygon;

    public RadarChart(int width, int height) {
        super(width, height, new RadarStyler());
        this.plot = new Plot_Radar<RadarStyler, RadarSeries>(this);
        this.legend = new Legend_Pie<RadarStyler, RadarSeries>(this);
        this.infoPanel = new InfoPanel<RadarStyler, RadarSeries>(this);
    }

    public RadarChart(int width, int height, Theme theme) {
        this(width, height);
        ((RadarStyler)this.styler).setTheme(theme);
    }

    public RadarChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public RadarChart(RadarChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
    }

    public RadarSeries addSeries(String seriesName, double[] values) {
        return this.addSeries(seriesName, values, null);
    }

    public RadarSeries addSeries(String seriesName, double[] values, String[] tooltipOverrides) {
        this.sanityCheck(seriesName, values, tooltipOverrides);
        RadarSeries series = new RadarSeries(seriesName, values, tooltipOverrides);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private void sanityCheck(String seriesName, double[] values, String[] annotations) {
        if (this.variableLabels == null) {
            throw new IllegalArgumentException("Variable labels cannot be null!!!");
        }
        if (this.seriesMap.keySet().contains(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values data cannot be null!!!");
        }
        if (values.length < this.variableLabels.length) {
            throw new IllegalArgumentException("Too few values!!!");
        }
        for (double d : values) {
            if (!(d < 0.0) && !(d > 1.0)) continue;
            throw new IllegalArgumentException("Values must be in [0, 1] range!!!");
        }
        if (annotations != null && annotations.length < this.variableLabels.length) {
            throw new IllegalArgumentException("Too few tool tips!!!");
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setSeriesStyles();
        this.paintBackground(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
        this.infoPanel.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((RadarStyler)this.getStyler()).getSeriesColors(), ((RadarStyler)this.getStyler()).getSeriesMarkers(), ((RadarStyler)this.getStyler()).getSeriesLines());
        for (RadarSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    public String[] getVariableLabels() {
        return this.variableLabels;
    }

    public void setVariableLabels(String[] variableLabels) {
        this.variableLabels = variableLabels;
    }

    public RadarRenderStyle getRadarRenderStyle() {
        return this.radarRenderStyle;
    }

    public void setRadarRenderStyle(RadarRenderStyle radarRenderStyle) {
        this.radarRenderStyle = radarRenderStyle;
    }

    public static enum RadarRenderStyle {
        Polygon,
        Circle;

    }
}

