/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.services.IDisposable;

public class SlaveSelectionService
implements ISelectionService,
IDisposable {
    private final ListenerList<ISelectionListener> postListeners = new ListenerList(1);
    private final ListenerList<ISelectionListener> listeners = new ListenerList(1);
    private final Map<ISelectionListener, String> listenersToPartId = new HashMap<ISelectionListener, String>();
    private final Map<ISelectionListener, String> postListenersToPartId = new HashMap<ISelectionListener, String>();
    private final ISelectionService parentSelectionService;

    public SlaveSelectionService(ISelectionService parentSelectionService) {
        if (parentSelectionService == null) {
            throw new IllegalArgumentException("The parent selection service cannot be null");
        }
        this.parentSelectionService = parentSelectionService;
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        this.postListeners.add((Object)listener);
        this.parentSelectionService.addPostSelectionListener(listener);
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.listenersToPartId.put(listener, partId);
        this.parentSelectionService.addPostSelectionListener(partId, listener);
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add((Object)listener);
        this.parentSelectionService.addSelectionListener(listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        this.postListenersToPartId.put(listener, partId);
        this.parentSelectionService.addPostSelectionListener(partId, listener);
    }

    @Override
    public ISelection getSelection() {
        return this.parentSelectionService.getSelection();
    }

    @Override
    public ISelection getSelection(String partId) {
        return this.parentSelectionService.getSelection(partId);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        this.postListeners.remove((Object)listener);
        this.parentSelectionService.removePostSelectionListener(listener);
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.postListenersToPartId.remove(listener);
        this.parentSelectionService.removePostSelectionListener(partId, listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove((Object)listener);
        this.parentSelectionService.removeSelectionListener(listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        this.listenersToPartId.remove(listener);
        this.parentSelectionService.removeSelectionListener(partId, listener);
    }

    @Override
    public void dispose() {
        Object listener;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            this.parentSelectionService.removeSelectionListener((ISelectionListener)listener);
            ++n2;
        }
        this.listeners.clear();
        objectArray = this.postListeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            this.parentSelectionService.removePostSelectionListener((ISelectionListener)listener);
            ++n2;
        }
        this.postListeners.clear();
        for (Map.Entry<ISelectionListener, String> entry : this.listenersToPartId.entrySet()) {
            this.parentSelectionService.removeSelectionListener(entry.getValue(), entry.getKey());
        }
        this.listenersToPartId.clear();
        for (Map.Entry<ISelectionListener, String> entry : this.postListenersToPartId.entrySet()) {
            this.parentSelectionService.removePostSelectionListener(entry.getValue(), entry.getKey());
        }
        this.postListenersToPartId.clear();
    }
}

