/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.ui.internal.preferences.IDynamicPropertyMap;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.IPropertyMapListener;
import org.eclipse.ui.internal.preferences.PropertyListenerList;

public abstract class PropertyMapAdapter
implements IDynamicPropertyMap {
    private PropertyListenerList listeners;
    private int ignoreCount = 0;
    private ArrayList<String> queuedEvents = new ArrayList();

    @Override
    public final void addListener(IPropertyMapListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyListenerList();
            this.attachListener();
        }
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(IPropertyMapListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.detachListener();
                this.listeners = null;
            }
        }
    }

    @Override
    public final boolean isCommonProperty(String propertyId) {
        return true;
    }

    public void dispose() {
        if (this.listeners != null) {
            this.detachListener();
            this.listeners = null;
        }
    }

    protected final void firePropertyChange(String prefId) {
        if (this.ignoreCount > 0) {
            this.queuedEvents.add(prefId);
            return;
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange(prefId);
        }
    }

    @Override
    public final void addListener(String[] eventsOfInterest, IPropertyMapListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyListenerList();
            this.attachListener();
        }
        this.listeners.add(eventsOfInterest, listener);
    }

    protected final void firePropertyChange(String[] prefIds) {
        if (this.ignoreCount > 0) {
            this.queuedEvents.addAll(Arrays.asList(prefIds));
            return;
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange(prefIds);
        }
    }

    public final void startTransaction() {
        ++this.ignoreCount;
    }

    public final void endTransaction() {
        --this.ignoreCount;
        if (this.ignoreCount == 0 && !this.queuedEvents.isEmpty()) {
            if (this.listeners != null) {
                this.listeners.firePropertyChange(this.queuedEvents.toArray(new String[this.queuedEvents.size()]));
            }
            this.queuedEvents.clear();
        }
    }

    public boolean equals(Object toCompare) {
        return toCompare instanceof IPropertyMap && PropertyMapAdapter.isEqual(this, (IPropertyMap)toCompare);
    }

    private static boolean isEqual(IPropertyMap map1, IPropertyMap map2) {
        Set<String> map2Keys;
        Set<String> map1Keys = map1.keySet();
        if (!map1Keys.equals(map2Keys = map2.keySet())) {
            return false;
        }
        for (String next : map1Keys) {
            if (map1.getValue(next, Object.class).equals(map2.getValue(next, Object.class))) continue;
            return false;
        }
        return true;
    }

    protected abstract void attachListener();

    protected abstract void detachListener();
}

