/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Arrays;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.ValidateProjectEncoding;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class ProjectEncodingMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    @Override
    public IMarkerResolution[] getResolutions(IMarker marker) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            String defaultCharset = workspace.getRoot().getDefaultCharset();
            IMarkerResolution[] resolutions = new IMarkerResolution[]{new ExplicitEncodingResolution(defaultCharset)};
            return resolutions;
        }
        catch (CoreException e) {
            UIPlugin.getDefault().getLog().log(e.getStatus());
            return new IMarkerResolution[0];
        }
    }

    @Override
    public boolean hasResolutions(IMarker marker) {
        return ProjectEncodingMarkerResolutionGenerator.canResolve(marker);
    }

    private static boolean canResolve(IMarker marker) {
        String type;
        try {
            type = marker.getType();
        }
        catch (CoreException e) {
            return false;
        }
        IResource resource = marker.getResource();
        return ValidateProjectEncoding.MARKER_TYPE.equals(type) && resource instanceof IProject;
    }

    private static class ExplicitEncodingResolution
    extends WorkbenchMarkerResolution {
        private final String charset;
        private Image image;

        private ExplicitEncodingResolution(String encoding) {
            this.charset = encoding;
            ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/elcl16/selected_mode.png").ifPresent(d -> {
                Image image = this.image = d.createImage();
            });
        }

        @Override
        public String getDescription() {
            return NLS.bind((String)MarkerMessages.ProjectEncodingMarkerResolution_description, (Object)this.charset);
        }

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public String getLabel() {
            return NLS.bind((String)MarkerMessages.ProjectEncodingMarkerResolution_label, (Object)this.charset);
        }

        @Override
        public void run(IMarker marker) {
            Runnable task = () -> this.run(marker);
            if (Display.getCurrent() != null) {
                ExplicitEncodingResolution.runAsWorkspaceJob(task, this.getLabel());
                return;
            }
            IResource resource = marker.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace instanceof Workspace) {
                    Workspace ws = (Workspace)workspace;
                    CharsetManager charsetManager = ws.getCharsetManager();
                    try {
                        charsetManager.setCharsetFor(project.getFullPath(), this.charset);
                    }
                    catch (CoreException e) {
                        UIPlugin.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        }

        @Override
        public void run(IMarker[] markers, IProgressMonitor monitor) {
            Runnable task = () -> super.run(markers, monitor);
            if (Display.getCurrent() == null) {
                task.run();
                return;
            }
            ExplicitEncodingResolution.runAsWorkspaceJob(task, this.getLabel());
        }

        private static void runAsWorkspaceJob(final Runnable task, String message) {
            WorkspaceJob job = new WorkspaceJob(message){

                public IStatus runInWorkspace(IProgressMonitor m) {
                    task.run();
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.setUser(true);
            job.schedule();
        }

        @Override
        public IMarker[] findOtherMarkers(IMarker[] markers) {
            IMarker[] otherMarkers = (IMarker[])Arrays.stream(markers).filter(m -> ProjectEncodingMarkerResolutionGenerator.canResolve(m)).toArray(IMarker[]::new);
            return otherMarkers;
        }
    }
}

