/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractClauseSelectorSolver;
import org.sat4j.tools.FullClauseSelectorSolver;
import org.sat4j.tools.GroupClauseSelectorSolver;
import org.sat4j.tools.Minimal4CardinalityModel;
import org.sat4j.tools.Minimal4InclusionModel;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMUSes {
    private AbstractClauseSelectorSolver<ISolver> css;
    private final List<IVecInt> mssList;
    private final List<IVecInt> secondPhaseClauses;
    private final List<IVecInt> musList;
    private final ASolverFactory<? extends ISolver> factory;

    public AllMUSes(boolean group, ASolverFactory<? extends ISolver> factory) {
        this.css = !group ? new FullClauseSelectorSolver<ISolver>(factory.defaultSolver(), false) : new GroupClauseSelectorSolver<ISolver>(factory.defaultSolver());
        this.mssList = new ArrayList<IVecInt>();
        this.musList = new ArrayList<IVecInt>();
        this.secondPhaseClauses = new ArrayList<IVecInt>();
        this.factory = factory;
    }

    public AllMUSes(ASolverFactory<? extends ISolver> factory) {
        this(false, factory);
    }

    public <T extends ISolver> T getSolverInstance() {
        return (T)this.css;
    }

    public List<IVecInt> computeAllMUSes() {
        return this.computeAllMUSes(SolutionFoundListener.VOID);
    }

    public List<IVecInt> computeAllMUSes(SolutionFoundListener listener) {
        if (this.secondPhaseClauses.isEmpty()) {
            this.computeAllMSS();
        }
        ISolver solver = this.factory.defaultSolver();
        for (IVecInt v : this.secondPhaseClauses) {
            try {
                solver.addClause(v);
            }
            catch (ContradictionException contradictionException) {
                return this.musList;
            }
        }
        Minimal4InclusionModel minSolver = new Minimal4InclusionModel(solver, Minimal4InclusionModel.positiveLiterals(solver));
        return this.computeAllMUSes(listener, minSolver);
    }

    public List<IVecInt> computeAllMUSesOrdered(SolutionFoundListener listener) {
        if (this.secondPhaseClauses.isEmpty()) {
            this.computeAllMSS();
        }
        ISolver solver = this.factory.defaultSolver();
        for (IVecInt v : this.secondPhaseClauses) {
            try {
                solver.addClause(v);
            }
            catch (ContradictionException contradictionException) {
                return this.musList;
            }
        }
        Minimal4CardinalityModel minSolver = new Minimal4CardinalityModel(solver, Minimal4InclusionModel.positiveLiterals(solver));
        return this.computeAllMUSes(listener, minSolver);
    }

    private List<IVecInt> computeAllMUSes(SolutionFoundListener listener, ISolver minSolver) {
        if (this.css.isVerbose()) {
            System.out.println(String.valueOf(this.css.getLogPrefix()) + "Computing all MUSes ...");
        }
        this.css.internalState();
        try {
            while (minSolver.isSatisfiable()) {
                VecInt blockingClause = new VecInt();
                VecInt mus = new VecInt();
                int[] model = minSolver.model();
                int i = 0;
                while (i < model.length) {
                    if (model[i] > 0) {
                        blockingClause.push(-model[i]);
                        mus.push(model[i]);
                    }
                    ++i;
                }
                this.musList.add(mus);
                listener.onSolutionFound(mus);
                minSolver.addBlockingClause(blockingClause);
            }
        }
        catch (ContradictionException contradictionException) {
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        if (this.css.isVerbose()) {
            System.out.println(String.valueOf(this.css.getLogPrefix()) + "... done.");
        }
        this.css.externalState();
        return this.musList;
    }

    public List<IVecInt> computeAllMSS() {
        return this.computeAllMSS(SolutionFoundListener.VOID);
    }

    public List<IVecInt> computeAllMSS(SolutionFoundListener listener) {
        VecInt pLits = new VecInt();
        for (Integer i : this.css.getAddedVars()) {
            pLits.push(i);
        }
        Minimal4InclusionModel min4Inc = new Minimal4InclusionModel(this.css, pLits);
        return this.computeAllMSS(listener, min4Inc, pLits);
    }

    public List<IVecInt> computeAllMSSOrdered(SolutionFoundListener listener) {
        VecInt pLits = new VecInt();
        for (Integer i : this.css.getAddedVars()) {
            pLits.push(i);
        }
        Minimal4CardinalityModel min4Inc = new Minimal4CardinalityModel(this.css, pLits);
        return this.computeAllMSS(listener, min4Inc, pLits);
    }

    private List<IVecInt> computeAllMSS(SolutionFoundListener listener, ISolver min4Inc, IVecInt pLits) {
        if (this.css.isVerbose()) {
            System.out.println(String.valueOf(this.css.getLogPrefix()) + "Computing all MSSes ...");
        }
        this.css.internalState();
        int nVar = this.css.nVars();
        VecInt fullMSS = new VecInt();
        int i = 0;
        while (i < this.css.getAddedVars().size()) {
            fullMSS.push(i + 1);
            ++i;
        }
        try {
            while (min4Inc.isSatisfiable()) {
                int[] fullmodel = min4Inc.modelWithInternalVariables();
                VecInt mss = new VecInt();
                fullMSS.copyTo(mss);
                VecInt blockingClause = new VecInt();
                VecInt secondPhaseClause = new VecInt();
                int i2 = 0;
                while (i2 < pLits.size()) {
                    int clause = Math.abs(pLits.get(i2));
                    if (fullmodel[clause - 1] > 0) {
                        blockingClause.push(-clause);
                        secondPhaseClause.push(clause - nVar);
                        mss.remove(clause - nVar);
                    }
                    ++i2;
                }
                this.mssList.add(mss);
                listener.onSolutionFound(mss);
                this.secondPhaseClauses.add(secondPhaseClause);
                this.css.addBlockingClause(blockingClause);
            }
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (ContradictionException contradictionException) {}
        if (this.css.isVerbose()) {
            System.out.println(String.valueOf(this.css.getLogPrefix()) + "... done.");
        }
        this.css.externalState();
        return this.mssList;
    }

    public List<IVecInt> getMssList() {
        return this.mssList;
    }
}

